/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.classify.transform;

import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.BasicFeatureIndex;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Feature;
import edu.cmu.minorthird.classify.Instance;
import edu.cmu.minorthird.classify.algorithms.random.NegativeBinomial;
import edu.cmu.minorthird.classify.algorithms.random.Poisson;
import edu.cmu.minorthird.classify.transform.InstanceTransform;
import edu.cmu.minorthird.classify.transform.MaskedInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class T1InstanceTransform
implements InstanceTransform {
    private double ALPHA = 0.05;
    private int MIN_WORDS = 50;
    private int MAX_WORDS = Integer.MAX_VALUE;
    private int SAMPLE = 2500;
    private Map<Feature, Double> T1values = new TreeMap<Feature, Double>();
    private Map<Feature, Double> muPosExamples = new TreeMap<Feature, Double>();
    private Map<Feature, Double> deltaPosExamples;
    private Map<Feature, Double> muNegExamples = new TreeMap<Feature, Double>();
    private Map<Feature, Double> deltaNegExamples;
    private Map<Feature, String> featurePdf;

    public T1InstanceTransform() {
        this.deltaPosExamples = new TreeMap<Feature, Double>();
        this.deltaNegExamples = new TreeMap<Feature, Double>();
        this.featurePdf = new TreeMap<Feature, String>();
    }

    @Override
    public Instance transform(Instance instance) {
        System.out.println("Warning: cannot transform instance with T1 Statistic!");
        return instance;
    }

    @Override
    public Example transform(Example example) {
        System.out.println("Warning: cannot transform example with T1 Statistic!");
        return example;
    }

    @Override
    public Dataset transform(Dataset dataset) {
        BasicFeatureIndex index = new BasicFeatureIndex(dataset);
        Comparator<Pair> VAL_COMPARATOR = new Comparator<Pair>(){

            @Override
            public int compare(Pair p1, Pair p2) {
                if (p1.value < p2.value) {
                    return -1;
                }
                if (p1.value > p2.value) {
                    return 1;
                }
                return p1.feature.compareTo(p2.feature);
            }
        };
        ArrayList<Pair> pValue = new ArrayList<Pair>();
        Iterator<Feature> i = index.featureIterator();
        while (i.hasNext()) {
            Feature f = i.next();
            double[] T1array = this.sampleT1Values(f);
            Pair p = this.computePValue(T1array, f);
            pValue.add(p);
        }
        SortedMap<Feature, Integer> availableFeatures = this.selectFeaturesViaFDR(pValue, VAL_COMPARATOR);
        BasicDataset maskeDataset = this.createMaskedDataset(dataset, availableFeatures);
        return maskeDataset;
    }

    private BasicDataset createMaskedDataset(Dataset dataset, SortedMap<Feature, Integer> availableFeatures) {
        BasicDataset maskeDataset = new BasicDataset();
        Iterator<Example> i = dataset.iterator();
        while (i.hasNext()) {
            Example e = i.next();
            MaskedInstance mi = new MaskedInstance(e.asInstance(), availableFeatures);
            Example ex = new Example(mi, e.getLabel());
            maskeDataset.add(ex);
        }
        return maskeDataset;
    }

    private SortedMap<Feature, Integer> selectFeaturesViaFDR(List<Pair> pValue, Comparator<Pair> VAL_COMPARATOR) {
        int j;
        TreeMap<Feature, Integer> availableFeatures = new TreeMap<Feature, Integer>();
        Collections.sort(pValue, VAL_COMPARATOR);
        int greatestIndexBeforeAccept = -1;
        for (j = 1; j <= pValue.size(); ++j) {
            double line = (double)j * this.ALPHA / (double)pValue.size();
            if (!(line > pValue.get((int)(j - 1)).value)) continue;
            greatestIndexBeforeAccept = j - 1;
        }
        greatestIndexBeforeAccept = Math.min(this.MAX_WORDS, Math.min(pValue.size() - 1, Math.max(greatestIndexBeforeAccept, this.MIN_WORDS)));
        System.out.println("Retained " + greatestIndexBeforeAccept + " fetures, out of " + pValue.size());
        for (j = 0; j <= greatestIndexBeforeAccept; ++j) {
            availableFeatures.put(pValue.get((int)j).feature, new Integer(1));
        }
        return availableFeatures;
    }

    private double[] sampleT1Values(Feature f) {
        double[] T1array = new double[this.SAMPLE];
        String s = this.featurePdf.get(f);
        if (s.equals("Poisson")) {
            Poisson Xp = new Poisson(this.getPosMu(f));
            Poisson Xn = new Poisson(this.getNegMu(f));
            for (int cnt = 0; cnt < this.SAMPLE; ++cnt) {
                T1array[cnt] = this.T1(Xp.nextInt(), Xn.nextInt());
            }
        } else if (s.equals("Negative-Binomial")) {
            SortedMap<String, Number> npPos = this.mudelta2np(this.getPosMu(f), this.getPosDelta(f), 1.0);
            SortedMap<String, Number> npNeg = this.mudelta2np(this.getNegMu(f), this.getNegDelta(f), 1.0);
            NegativeBinomial Xp = new NegativeBinomial(((Number)npPos.get("n")).intValue(), ((Number)npPos.get("p")).doubleValue());
            NegativeBinomial Xn = new NegativeBinomial(((Number)npNeg.get("n")).intValue(), ((Number)npNeg.get("p")).doubleValue());
            for (int cnt = 0; cnt < this.SAMPLE; ++cnt) {
                T1array[cnt] = this.T1(Xp.nextInt(), Xn.nextInt());
            }
        } else {
            throw new IllegalStateException("Error: PDF not implemented!");
        }
        return T1array;
    }

    private Pair computePValue(double[] t1array, Feature feature) {
        Arrays.sort(t1array);
        int newLength = 0;
        for (int j = 0; j < t1array.length; ++j) {
            if (new Double(t1array[j]).isNaN()) {
                newLength = j;
                break;
            }
            newLength = t1array.length;
        }
        int greatestIndexBeforeT1Observed = 0;
        for (int j = 0; j < t1array.length; ++j) {
            if (!(t1array[j] < this.T1values.get(feature))) continue;
            greatestIndexBeforeT1Observed = j;
        }
        Pair p = new Pair((double)(newLength - greatestIndexBeforeT1Observed) / (double)newLength, feature);
        return p;
    }

    public void setMIN_WORDS(int number) {
        this.MIN_WORDS = number;
    }

    public void setMAX_WORDS(int number) {
        this.MAX_WORDS = number;
    }

    public void setSAMPLE(int size) {
        this.SAMPLE = size;
    }

    public void setALPHA(double desiredLevel) {
        this.ALPHA = desiredLevel;
    }

    public void setFeaturePdf(Feature f, String pdf) {
        this.featurePdf.put(f, new String(pdf));
    }

    public void setT1(Feature f, double delta) {
        Double d = this.T1values.get(f);
        if (d == null) {
            this.T1values.put(f, new Double(delta));
        } else {
            System.out.println("Warning: T1 value already set for feature " + f.toString() + "!");
        }
    }

    public void setPosMu(Feature f, double delta) {
        Double d = this.muPosExamples.get(f);
        if (d == null) {
            this.muPosExamples.put(f, new Double(delta));
        } else {
            this.muPosExamples.put(f, new Double(d + delta));
        }
    }

    public double getPosMu(Feature f) {
        Double d = this.muPosExamples.get(f);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void setNegMu(Feature f, double delta) {
        Double d = this.muNegExamples.get(f);
        if (d == null) {
            this.muNegExamples.put(f, new Double(delta));
        } else {
            this.muNegExamples.put(f, new Double(d + delta));
        }
    }

    public double getNegMu(Feature f) {
        Double d = this.muNegExamples.get(f);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void setPosDelta(Feature f, double delta) {
        Double d = this.deltaPosExamples.get(f);
        if (d == null) {
            this.deltaPosExamples.put(f, new Double(delta));
        } else {
            this.deltaPosExamples.put(f, new Double(d + delta));
        }
    }

    public double getPosDelta(Feature f) {
        Double d = this.deltaPosExamples.get(f);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public void setNegDelta(Feature f, double delta) {
        Double d = this.deltaNegExamples.get(f);
        if (d == null) {
            this.deltaNegExamples.put(f, new Double(delta));
        } else {
            this.deltaNegExamples.put(f, new Double(d + delta));
        }
    }

    public double getNegDelta(Feature f) {
        Double d = this.deltaNegExamples.get(f);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public double T1(int x1, int x2) {
        double dx1 = new Integer(x1).doubleValue();
        double dx2 = new Integer(x2).doubleValue();
        double t = Math.pow(dx1 - dx2, 2.0) / (dx1 + dx2);
        return t;
    }

    public SortedMap<String, Number> mudelta2np(double mu, double delta, double omega) {
        TreeMap<String, Number> np = new TreeMap<String, Number>();
        int n = (int)Math.ceil(new Double(mu / delta));
        np.put("n", new Integer(n));
        double p = omega * delta;
        np.put("p", new Double(p));
        return np;
    }

    private class Pair {
        double value;
        Feature feature;

        public Pair(double v, Feature f) {
            this.value = v;
            this.feature = f;
        }

        public String toString() {
            return "[ " + this.value + "," + this.feature + " ]";
        }
    }
}

