/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanDifference;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.gui.HiliteColors;
import edu.cmu.minorthird.text.learn.SampleExtractionProblem;
import edu.cmu.minorthird.util.gui.Controllable;
import edu.cmu.minorthird.util.gui.ControlledViewer;
import edu.cmu.minorthird.util.gui.VanillaViewer;
import edu.cmu.minorthird.util.gui.ViewerControls;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import javax.swing.text.SimpleAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupControls
extends ViewerControls {
    static final long serialVersionUID = 20080305L;
    private static Map<String, SimpleAttributeSet> colorMap = new TreeMap<String, SimpleAttributeSet>();
    private static final int NUM_COLOR_BOXES = 5;
    protected TextLabels labels;
    protected List<String> types = new ArrayList<String>();
    private Map<String, String> typeColorCode = new HashMap<String, String>();
    private Map<String, Map<String, String>> propColorCode = new HashMap<String, Map<String, String>>();
    private JComboBox guessBox;
    private JComboBox truthBox;
    private SpanDifference sd;
    private List<JComboBox> boxList = new ArrayList<JComboBox>();

    public MarkupControls(TextLabels labels) {
        this.labels = labels;
        this.types = new ArrayList<String>(labels.getTypes());
        this.typeColorCode = new HashMap<String, String>();
        this.initialize();
    }

    @Override
    protected void initialize() {
        if (this.types == null) {
            return;
        }
        this.setLayout(new GridBagLayout());
        JPanel subpanel = new JPanel();
        subpanel.setLayout(new GridBagLayout());
        this.guessBox = new JComboBox();
        this.guessBox.addItem("-compare- ");
        this.truthBox = new JComboBox();
        this.truthBox.addItem("-to-");
        for (int i = 0; i < this.types.size(); ++i) {
            this.guessBox.addItem(this.types.get(i).toString());
            this.truthBox.addItem(this.types.get(i).toString());
        }
        ActionListener diffListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MarkupControls.this.guessBox.getSelectedIndex() == 0 || MarkupControls.this.truthBox.getSelectedIndex() == 0) {
                    MarkupControls.this.sd = null;
                } else {
                    String guess = MarkupControls.this.guessBox.getSelectedItem().toString();
                    String truth = MarkupControls.this.truthBox.getSelectedItem().toString();
                    MarkupControls.this.sd = new SpanDifference(MarkupControls.this.labels.instanceIterator(guess), MarkupControls.this.labels.instanceIterator(truth), MarkupControls.this.labels.closureIterator(truth));
                }
            }
        };
        this.guessBox.addActionListener(diffListener);
        this.truthBox.addActionListener(diffListener);
        JPanel comparePanel = new JPanel();
        comparePanel.setBorder(new TitledBorder("Compare types"));
        comparePanel.add(this.guessBox);
        comparePanel.add(this.truthBox);
        this.boxList.add(this.guessBox);
        this.boxList.add(this.truthBox);
        subpanel.add((Component)comparePanel, this.gbc(0));
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new GridBagLayout());
        for (int i = 0; i < 5; ++i) {
            JPanel boxPanel = new JPanel();
            JComboBox colorBox = this.makeBox("color", colorMap.keySet());
            JComboBox typeBox = this.makeBox("type", this.types);
            boxPanel.add(colorBox);
            boxPanel.add(typeBox);
            this.boxList.add(colorBox);
            this.boxList.add(typeBox);
            ColorTypeBoxListener boxListener = new ColorTypeBoxListener(colorBox, typeBox);
            colorBox.addActionListener(boxListener);
            typeBox.addActionListener(boxListener);
            typePanel.add((Component)boxPanel, this.gbc(i));
        }
        JPanel propPanel = new JPanel();
        propPanel.setLayout(new GridBagLayout());
        for (int i = 0; i < 5; ++i) {
            JPanel boxPanel = new JPanel();
            JComboBox colorBox = this.makeBox("color", colorMap.keySet());
            JComboBox propBox = this.makeBox("property", this.propValuePairs());
            boxPanel.add(colorBox);
            boxPanel.add(propBox);
            this.boxList.add(colorBox);
            this.boxList.add(propBox);
            ColorPropBoxListener boxListener = new ColorPropBoxListener(colorBox, propBox);
            colorBox.addActionListener(boxListener);
            propBox.addActionListener(boxListener);
            propPanel.add((Component)boxPanel, this.gbc(i));
        }
        JPanel summaryPanel = new JPanel();
        summaryPanel.setLayout(new GridBagLayout());
        summaryPanel.add((Component)new JLabel("Documents:"), this.gbc(0, 0));
        summaryPanel.add((Component)new JLabel(Integer.toString(this.labels.getTextBase().size())), this.gbc(0, 1));
        summaryPanel.add((Component)new JLabel("Token Properties:"), this.gbc(1, 0));
        summaryPanel.add((Component)new JLabel(Integer.toString(this.labels.getTokenProperties().size())), this.gbc(1, 1));
        summaryPanel.add((Component)new JLabel("Span Properties:"), this.gbc(2, 0));
        summaryPanel.add((Component)new JLabel(Integer.toString(this.labels.getSpanProperties().size())), this.gbc(2, 1));
        summaryPanel.add((Component)new JLabel("Span Types:"), this.gbc(3, 0));
        summaryPanel.add((Component)new JLabel(Integer.toString(this.labels.getTypes().size())), this.gbc(3, 1));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Summary", summaryPanel);
        tabbedPane.add("SpanTypes", typePanel);
        tabbedPane.add("SpanProps", propPanel);
        subpanel.add((Component)tabbedPane, this.gbc(1));
        JPanel applyPanel = new JPanel();
        applyPanel.setBorder(new TitledBorder("Update display"));
        applyPanel.add(this.makeApplyButton());
        applyPanel.add(this.makeResetButton());
        subpanel.add((Component)applyPanel, this.gbc(2));
        GridBagConstraints gbc = this.gbc(0);
        gbc.fill = 1;
        this.add((Component)new JScrollPane(subpanel), gbc);
    }

    @Override
    public int preferredLocation() {
        return 2;
    }

    @Override
    public boolean prefersToBeResized() {
        return true;
    }

    private Set<String> propValuePairs() {
        TreeSet<String> accum = new TreeSet<String>();
        Set<String> props = this.labels.getSpanProperties();
        for (String prop : props) {
            Iterator<Span> j = this.labels.getSpansWithProperty(prop);
            while (j.hasNext()) {
                Span s = j.next();
                String val = this.labels.getProperty(s, prop);
                accum.add(this.packPropValue(prop, val));
            }
        }
        return accum;
    }

    private String packPropValue(String p, String v) {
        return p + "=" + v;
    }

    private String[] unpackPropValue(String pv) {
        return pv.split("=");
    }

    private JButton makeResetButton() {
        return new JButton(new AbstractAction("-reset controls-"){
            static final long serialVersionUID = 20080306L;

            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < MarkupControls.this.boxList.size(); ++i) {
                    ((JComboBox)MarkupControls.this.boxList.get(i)).setSelectedIndex(0);
                }
            }
        });
    }

    private JComboBox makeBox(String tag, Collection<?> c) {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem("-select " + tag + "-");
        Iterator<?> j = c.iterator();
        while (j.hasNext()) {
            box.addItem((String)j.next());
        }
        return box;
    }

    private void putPropCode(String p, String v, String color) {
        Map<String, String> m = this.propColorCode.get(p);
        if (m == null) {
            m = new HashMap<String, String>();
            this.propColorCode.put(p, m);
        }
        m.put(v, color);
    }

    private void removePropCode(String p, String v) {
        Map<String, String> m = this.propColorCode.get(p);
        if (m == null) {
            m = new HashMap<String, String>();
            this.propColorCode.put(p, m);
        }
        m.remove(v);
    }

    private GridBagConstraints gbc(int i) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = i;
        return gbc;
    }

    private GridBagConstraints gbc(int row, int col) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.ipadx = 20;
        gbc.anchor = col == 1 ? 17 : 13;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridx = col;
        gbc.gridy = row;
        return gbc;
    }

    public SimpleAttributeSet getColor(String type) {
        String s = this.typeColorCode.get(type);
        if (s == null) {
            return null;
        }
        return colorMap.get(s);
    }

    public SimpleAttributeSet getColor(String prop, String value) {
        Map<String, String> m = this.propColorCode.get(prop);
        if (m == null) {
            return null;
        }
        String s = m.get(value);
        if (s == null) {
            return null;
        }
        return colorMap.get(s);
    }

    public Set<String> getColoredProperties() {
        return this.propColorCode.keySet();
    }

    public Set<String> getColoredValues(String prop) {
        Map<String, String> m = this.propColorCode.get(prop);
        if (m == null) {
            return Collections.EMPTY_SET;
        }
        return m.keySet();
    }

    public SpanDifference getSpanDifference() {
        return this.sd;
    }

    public static void main(String[] argv) {
        try {
            TextLabels labels = SampleExtractionProblem.trainLabels();
            ControlledViewer v = new ControlledViewer(new TestViewer(), new MarkupControls(labels));
            new ViewerFrame("MarkupControls", v);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        colorMap.put("blue", HiliteColors.blue);
        colorMap.put("red", HiliteColors.red);
        colorMap.put("green", HiliteColors.green);
        colorMap.put("yellow", HiliteColors.yellow);
        colorMap.put("gray", HiliteColors.gray);
    }

    private static class TestViewer
    extends VanillaViewer
    implements Controllable {
        static final long serialVersionUID = 20080306L;

        public TestViewer() {
            super("yow");
        }

        public void applyControls(ViewerControls controls) {
            System.out.println("applied " + controls);
        }
    }

    private class ColorPropBoxListener
    implements ActionListener {
        private JComboBox colorBox;
        private JComboBox propValBox;
        private String[] propVal = null;

        public ColorPropBoxListener(JComboBox colorBox, JComboBox propValBox) {
            this.colorBox = colorBox;
            this.propValBox = propValBox;
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.propValBox.getSelectedIndex() > 0) {
                this.propVal = MarkupControls.this.unpackPropValue((String)this.propValBox.getSelectedItem());
                if (this.colorBox.getSelectedIndex() != 0) {
                    MarkupControls.this.putPropCode(this.propVal[0], this.propVal[1], (String)this.colorBox.getSelectedItem());
                } else {
                    MarkupControls.this.removePropCode(this.propVal[0], this.propVal[1]);
                }
            } else {
                if (this.propVal != null) {
                    MarkupControls.this.removePropCode(this.propVal[0], this.propVal[1]);
                }
                this.propVal = null;
            }
        }
    }

    private class ColorTypeBoxListener
    implements ActionListener {
        private JComboBox colorBox;
        private JComboBox typeBox;
        private String type = null;

        public ColorTypeBoxListener(JComboBox colorBox, JComboBox typeBox) {
            this.colorBox = colorBox;
            this.typeBox = typeBox;
        }

        public void actionPerformed(ActionEvent ev) {
            if (this.typeBox.getSelectedIndex() > 0) {
                this.type = (String)this.typeBox.getSelectedItem();
                if (this.colorBox.getSelectedIndex() != 0) {
                    MarkupControls.this.typeColorCode.put(this.type, (String)this.colorBox.getSelectedItem());
                } else {
                    MarkupControls.this.typeColorCode.remove(this.type);
                }
            } else {
                if (this.type != null) {
                    MarkupControls.this.typeColorCode.remove(this.type);
                }
                this.type = null;
            }
        }
    }
}

