/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.gui;

import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.SampleTextBases;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.gui.OnlineClassifierDocumentEditor;
import edu.cmu.minorthird.text.gui.StatusMessage;
import edu.cmu.minorthird.text.gui.TextBaseEditor;
import edu.cmu.minorthird.text.gui.TextBaseViewer;
import edu.cmu.minorthird.text.gui.TrackedTextBaseComponent;
import edu.cmu.minorthird.text.learn.OnlineTextClassifierLearner;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;

public class OnlineLearnerEditor
extends TrackedTextBaseComponent {
    static final long serialVersionUID = 200803014L;
    private OnlineClassifierDocumentEditor ocdEditor;

    public OnlineClassifierDocumentEditor getOnlineClassifierDocumentEditor() {
        return this.ocdEditor;
    }

    protected OnlineLearnerEditor(String[] args) {
        this.log.debug("construct");
        try {
            this.setLabels(args);
        }
        catch (IOException e) {
            this.log.fatal(e, e);
        }
    }

    public OnlineLearnerEditor(TextBase base, TextLabels viewLabels, MutableTextLabels editLabels, String key, StatusMessage statusMsg, boolean readOnly, OnlineTextClassifierLearner learner) {
        this.init(base, viewLabels, statusMsg, editLabels, key, readOnly, learner);
    }

    private void init(TextBase base, TextLabels viewLabels, StatusMessage statusMsg, MutableTextLabels editLabels, String key, boolean readOnly, OnlineTextClassifierLearner learner) {
        super.init(base, viewLabels, editLabels, statusMsg);
        this.viewer = new TextBaseViewer(base, viewLabels, statusMsg);
        this.createOnlineClassifierDocumentEditor(viewLabels, this.viewer, editLabels, statusMsg, learner);
        this.ocdEditor = (OnlineClassifierDocumentEditor)this.viewerTracker;
        File saveLabels = new File(key + ".labels");
        this.ocdEditor.setSaveAs(saveLabels);
        this.viewer.getTruthBox().addActionListener(new EditTypeAction(this.viewer.getGuessBox(), this.viewer.getTruthBox(), this.ocdEditor));
        this.viewer.getGuessBox().addActionListener(new EditTypeAction(this.viewer.getGuessBox(), this.viewer.getTruthBox(), this.ocdEditor));
        this.viewer.getDocumentList().addListSelectionListener(this.ocdEditor);
        this.ocdEditor.setReadOnly(readOnly);
        this.initializeLayout();
    }

    protected void createOnlineClassifierDocumentEditor(TextLabels viewLabels, TextBaseViewer viewer, MutableTextLabels editLabels, StatusMessage statusMsg, OnlineTextClassifierLearner learner) {
        this.viewerTracker = new OnlineClassifierDocumentEditor(learner, viewLabels, viewer, editLabels, viewer.getDocumentList(), viewer.getSpanPainter(), statusMsg);
    }

    public static OnlineLearnerEditor edit(TextLabels labels, MutableTextLabels editLabels, String rk, OnlineTextClassifierLearner learner) {
        TextBase textBase = labels.getTextBase();
        StatusMessage statusMsg = new StatusMessage();
        OnlineLearnerEditor editor = new OnlineLearnerEditor(textBase, labels, editLabels, rk, statusMsg, false, learner);
        editor.initializeLayout();
        editor.buildFrame();
        return editor;
    }

    private void setLabels(String[] args) throws IOException {
        boolean readOnly = OnlineLearnerEditor.checkReadOnly(args);
        TextBase base = null;
        MutableTextLabels labels = null;
        File saveFile = null;
        if (args.length == 0) {
            base = SampleTextBases.getTextBase();
            labels = SampleTextBases.getTruthLabels();
            this.log.info("Sample Text Bases");
        } else {
            this.log.debug("load from " + args[0]);
            labels = (MutableTextLabels)FancyLoader.loadTextLabels(args[0]);
            base = labels.getTextBase();
            if (args.length > 1) {
                saveFile = new File(args[1]);
                if (saveFile.exists()) {
                    labels = new TextLabelsLoader().loadOps(base, saveFile);
                }
                this.log.info("load text bases");
            }
        }
        this.init(base, labels, new StatusMessage(), labels, "default", readOnly, null);
        this.setSaveAs(saveFile);
    }

    private static boolean checkReadOnly(String[] args) {
        boolean readOnly = false;
        for (int argp = 0; argp < args.length; ++argp) {
            if (!"-readOnly".equals(args[argp])) continue;
            readOnly = true;
            ++argp;
        }
        return readOnly;
    }

    public static void main(String[] args) {
        try {
            MutableTextLabels labels = (MutableTextLabels)FancyLoader.loadTextLabels(args[0]);
            File saveFile = new File(args[1]);
            TextBaseEditor.edit(labels, saveFile);
        }
        catch (Exception e) {
            System.out.println("usage repositoryKey outputFile");
        }
    }

    public static class EditTypeAction
    extends AbstractAction {
        static final long serialVersionUID = 200803014L;
        private JComboBox guessBox;
        private JComboBox truthBox;
        private OnlineClassifierDocumentEditor ocdEditor;

        public EditTypeAction(JComboBox guessBox, JComboBox truthBox, OnlineClassifierDocumentEditor ocdEditor) {
            this.guessBox = guessBox;
            this.truthBox = truthBox;
            this.ocdEditor = ocdEditor;
        }

        public void actionPerformed(ActionEvent event) {
            String truthType = (String)this.truthBox.getSelectedItem();
            String guessType = (String)this.guessBox.getSelectedItem();
            if (!"-compare to-".equals(truthType)) {
                this.ocdEditor.setTypesBeingEdited(guessType, truthType);
            } else {
                this.ocdEditor.setTypesBeingEdited(guessType, guessType);
            }
        }
    }
}

