/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.learn.AnnotationExample;
import edu.cmu.minorthird.text.learn.Extraction2TaggingReduction;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeginContinueOutsideReduction
extends Extraction2TaggingReduction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient NestedTextLabels taggedLabels;
    private String tokenProp = "_entityPart";
    private Set<String> tagset = new HashSet<String>();
    private boolean useSpanType = true;

    @Override
    public void reduceExtraction2Tagging(AnnotationExample example) {
        this.reduceDocument(example.getDocumentSpan(), example.getLabels(), example.getInputType(), example.getInputProp());
    }

    private void reduceDocument(Span doc, TextLabels labels, String spanType, String spanProp) {
        Iterator<Span> i;
        this.useSpanType = spanType != null;
        this.taggedLabels = new NestedTextLabels(labels);
        this.assignDefaultLabels(doc, this.taggedLabels, spanType, spanProp);
        String id = doc.getDocumentId();
        Iterator<Span> iterator = i = this.useSpanType ? this.taggedLabels.instanceIterator(spanType, id) : this.taggedLabels.getSpansWithProperty(spanProp, id);
        while (i.hasNext()) {
            Span span = i.next();
            String baseTag = this.useSpanType ? spanType : this.taggedLabels.getProperty(span, spanProp);
            this.tagset.add(baseTag);
            String beginTag = baseTag + "Begin";
            this.taggedLabels.setProperty(span.getToken(0), this.tokenProp, beginTag);
            String contTag = baseTag + "Continue";
            for (int j = 1; j < span.size(); ++j) {
                this.taggedLabels.setProperty(span.getToken(j), this.tokenProp, contTag);
            }
        }
    }

    @Override
    public String getTokenProp() {
        return this.tokenProp;
    }

    @Override
    public Set<String> getNonDefaultTagValues() {
        HashSet<String> result = new HashSet<String>();
        for (String baseTag : this.tagset) {
            result.add(baseTag + "Begin");
            result.add(baseTag + "Continue");
        }
        return result;
    }

    @Override
    public TextLabels getTaggedLabels() {
        return this.taggedLabels;
    }

    @Override
    public void extractFromTags(String output, MonotonicTextLabels taggedLabels) {
        try {
            MixupProgram p = new MixupProgram();
            if (this.useSpanType) {
                String baseTag = this.tagset.iterator().next();
                p.addStatement("defSpanType " + output + " =: " + this.makePattern(baseTag));
            } else {
                for (String baseTag : this.tagset) {
                    p.addStatement("defSpanProp " + output + ":" + baseTag + " =: " + this.makePattern(baseTag));
                }
            }
            MixupInterpreter interp = new MixupInterpreter(p);
            interp.eval(taggedLabels);
        }
        catch (Mixup.ParseException ex) {
            throw new IllegalStateException("mixup error: " + ex);
        }
    }

    private String makePattern(String baseTag) {
        String p = this.tokenProp + ":" + baseTag;
        return "... [" + p + "Begin L " + p + "Continue* R ] ... ";
    }
}

