/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreqAnal {
    private TextLabels labels = null;
    private String spanType = "_prediction";
    private static final int TF = 0;
    private static final int DF = 1;
    private static final int PF = 2;
    private static final int HS = 3;
    private static final int LAST = 4;
    private static Map<String, Double[]> tokenHash = new HashMap<String, Double[]>();

    public FreqAnal(TextLabels labels, String spanType) {
        this.labels = labels;
        this.spanType = spanType;
        TextBase base = labels.getTextBase();
        Iterator<Span> i = base.documentSpanIterator();
        while (i.hasNext()) {
            Span docSpan = i.next();
            ArrayList<String> TFList = new ArrayList<String>();
            ArrayList<String> PFList = new ArrayList<String>();
            for (int j = 0; j < docSpan.size(); ++j) {
                Span tokenSpan = docSpan.subSpan(j, 1);
                if (FreqAnal.isPredictedName(spanType, tokenSpan, labels)) {
                    PFList.add(tokenSpan.asString().toLowerCase());
                }
                TFList.add(tokenSpan.asString().toLowerCase());
            }
            List<String> DFList = FreqAnal.uniqueList(TFList);
            FreqAnal.updateHash(TFList, 0);
            FreqAnal.updateHash(DFList, 1);
            FreqAnal.updateHash(PFList, 2);
        }
        FreqAnal.updateHScore(base.size(), 3);
    }

    public TextLabels getLabels() {
        return this.labels;
    }

    public void setLabels(TextLabels labels) {
        this.labels = labels;
    }

    public String getSpanType() {
        return this.spanType;
    }

    public void setSpanType(String spanType) {
        this.spanType = spanType;
    }

    public void print() {
        for (String next : tokenHash.keySet()) {
            Double[] array = tokenHash.get(next);
            System.out.println(next + " " + array[0] + " " + array[1] + " " + array[2] + " " + array[3]);
        }
    }

    private static void updateHScore(int numDoc, int type) {
        for (String token : tokenHash.keySet()) {
            Double[] array = tokenHash.get(token);
            if (array == null) {
                array = new Double[4];
                for (int j = 0; j < array.length; ++j) {
                    array[j] = new Double(0.0);
                }
            }
            array[type] = FreqAnal.TF_IDF(array, numDoc);
            System.out.println(token + " " + array[3]);
            tokenHash.put(token, array);
        }
    }

    private static Double TF_IDF(Double[] array, int numDoc) {
        return new Double(array[2] / (array[0] + 2.0) * Math.log(((double)numDoc + 0.5) / array[1]) / Math.log(numDoc + 1) * 100.0);
    }

    private static void updateHash(List<String> list, int type) {
        for (String token : list) {
            Double[] array = tokenHash.get(token);
            if (array == null) {
                array = new Double[4];
                for (int j = 0; j < array.length; ++j) {
                    array[j] = new Double(0.0);
                }
            }
            array[type] = new Double(array[type] + 1.0);
            tokenHash.put(token, array);
        }
    }

    private static boolean isPredictedName(String spanType, Span test, TextLabels labels) {
        Iterator<Span> i = labels.instanceIterator(spanType, test.getDocumentId());
        while (i.hasNext()) {
            Span name = i.next();
            if (!name.contains(test)) continue;
            return true;
        }
        return false;
    }

    public Double getHScore(String term) {
        Double[] array = tokenHash.get(term);
        return array != null ? array[3] : null;
    }

    private static List<String> uniqueList(List<String> list) {
        return new ArrayList<String>(new HashSet<String>(list));
    }
}

