/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.learn;

import edu.cmu.minorthird.classify.SampleDatasets;
import edu.cmu.minorthird.text.BasicTextBase;
import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import java.util.Iterator;

public class SampleClassificationProblem {
    public static TextLabels trainLabels() {
        return SampleClassificationProblem.makeLabels(SampleDatasets.posTrain, SampleDatasets.negTest);
    }

    public static TextLabels testLabels() {
        return SampleClassificationProblem.makeLabels(SampleDatasets.posTest, SampleDatasets.negTest);
    }

    public static TextLabels unlabeled() {
        int i;
        String[] pos = SampleDatasets.posTest;
        String[] neg = SampleDatasets.negTest;
        BasicTextBase base = new BasicTextBase();
        for (i = 0; i < pos.length; ++i) {
            base.loadDocument("pos." + i, pos[i]);
        }
        for (i = 0; i < neg.length; ++i) {
            base.loadDocument("neg." + i, neg[i]);
        }
        BasicTextLabels labels = new BasicTextLabels(base);
        return labels;
    }

    private static TextLabels makeLabels(String[] pos, String[] neg) {
        int i;
        BasicTextBase base = new BasicTextBase();
        for (i = 0; i < pos.length; ++i) {
            base.loadDocument("pos." + i, pos[i]);
        }
        for (i = 0; i < neg.length; ++i) {
            base.loadDocument("neg." + i, neg[i]);
        }
        BasicTextLabels labels = new BasicTextLabels(base);
        Iterator<Span> i2 = base.documentSpanIterator();
        while (i2.hasNext()) {
            Span s = i2.next();
            if (!s.getDocumentId().startsWith("pos")) continue;
            labels.addToType(s, "fun");
        }
        new TextLabelsLoader().closeLabels(labels, 1);
        return labels;
    }
}

