/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.text.mixup;

import edu.cmu.minorthird.text.BasicTextLabels;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.RegexTokenizer;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.SpanTypeTokenizer;
import edu.cmu.minorthird.text.SplitTokenizer;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextBaseManager;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextToken;
import edu.cmu.minorthird.text.Tokenizer;
import edu.cmu.minorthird.text.Trie;
import edu.cmu.minorthird.text.mixup.Mixup;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import edu.cmu.minorthird.text.mixup.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MixupInterpreter {
    private static Logger log = Logger.getLogger(MixupInterpreter.class);
    private MixupProgram program = null;
    private Map<String, MonotonicTextLabels> levelsToLabelsMap = new HashMap<String, MonotonicTextLabels>();
    private Stack<String> levelStack = new Stack();
    private TextBaseManager tbManager;

    public MixupInterpreter() {
    }

    public MixupInterpreter(MixupProgram p) {
        this.program = p;
    }

    public MixupInterpreter(MixupProgram p, MonotonicTextLabels rootLabels) {
        this.program = p;
        this.tbManager = new TextBaseManager("root", rootLabels.getTextBase());
        this.levelsToLabelsMap.put("root", rootLabels);
        this.levelStack.push("root");
    }

    public void eval(MonotonicTextLabels labels) {
        if (this.program == null) {
            throw new IllegalStateException("You must set the MixupProgram prior to calling eval.");
        }
        this.tbManager = new TextBaseManager("root", labels.getTextBase());
        this.levelsToLabelsMap.clear();
        this.levelsToLabelsMap.put("root", labels);
        this.levelStack = new Stack();
        this.levelStack.push("root");
        this.eval();
    }

    public void eval() {
        if (this.program == null) {
            throw new IllegalStateException("You must set the MixupProgram prior to calling eval.");
        }
        if (this.getCurrentLevel() == null) {
            throw new IllegalStateException("There is no TextLabels heirarchy.  You must call eval(TextLabels) instead.");
        }
        Statement[] statementList = this.program.getStatements();
        for (int i = 0; i < statementList.length; ++i) {
            this.evaluate(statementList[i]);
        }
    }

    public void setProgram(MixupProgram p) {
        this.program = p;
    }

    public MixupProgram getProgram() {
        return this.program;
    }

    public MonotonicTextLabels getLabelsForLevel(String level) {
        return this.levelsToLabelsMap.get(level);
    }

    public String getCurrentLevel() {
        if (this.levelStack.empty()) {
            return null;
        }
        return this.levelStack.peek();
    }

    public MonotonicTextLabels getCurrentLabels() {
        return this.getLabelsForLevel(this.getCurrentLevel());
    }

    public void onLevel(String levelName) {
        if (this.levelsToLabelsMap.get(levelName) == null) {
            throw new IllegalArgumentException("There is no level named '" + levelName + "'");
        }
        this.levelStack.push(levelName);
    }

    public void offLevel(String levelName) {
        if (this.levelStack.size() == 1) {
            throw new IllegalArgumentException("Already at the top level.");
        }
        if (!this.levelStack.peek().equals(levelName)) {
            throw new IllegalArgumentException("Not on level named '" + levelName + "'");
        }
        this.levelStack.pop();
    }

    public void createLevel(String newLevelName, String levelType, String pattern) {
        TextBase newTextBase = null;
        BasicTextLabels newLabels = null;
        String currentLevel = this.getCurrentLevel();
        MonotonicTextLabels parentLabels = this.levelsToLabelsMap.get(currentLevel);
        if ("pseudotoken".equals(levelType)) {
            SpanTypeTokenizer tokenizer = new SpanTypeTokenizer(pattern, parentLabels);
            newTextBase = this.tbManager.retokenize(tokenizer, currentLevel, newLevelName);
            newLabels = new BasicTextLabels(newTextBase);
            Iterator<Span> typeInstances = parentLabels.instanceIterator(pattern);
            while (typeInstances.hasNext()) {
                Span currInstance = typeInstances.next();
                Span matchingChildSpan = this.tbManager.getMatchingSpan(currInstance, currentLevel, newLevelName);
                for (int i = 0; i < matchingChildSpan.size(); ++i) {
                    newLabels.setProperty(matchingChildSpan.getTextToken(i), "Pseudotoken", "1");
                }
            }
        } else if ("filter".equals(levelType)) {
            newTextBase = this.tbManager.filter(currentLevel, parentLabels, newLevelName, pattern);
            newLabels = new BasicTextLabels(newTextBase);
        } else if ("re".equals(levelType) || "split".equals(levelType)) {
            Tokenizer tokenizer = levelType.equals("split") ? new SplitTokenizer(pattern) : new RegexTokenizer(pattern);
            newTextBase = this.tbManager.retokenize(tokenizer, currentLevel, newLevelName);
            newLabels = new BasicTextLabels(newTextBase);
        } else {
            throw new IllegalArgumentException("No level type: " + levelType + " new level created with old textBase and Labels");
        }
        this.levelsToLabelsMap.put(newLevelName, newLabels);
    }

    public void importLabelsFromLevel(String importLevel, String oldType, String newType) {
        if (!this.tbManager.containsLevel(importLevel)) {
            throw new IllegalArgumentException("Level: " + importLevel + " not defined for importFromLevel");
        }
        MonotonicTextLabels oldLabels = this.levelsToLabelsMap.get(importLevel);
        MonotonicTextLabels currLabels = this.getCurrentLabels();
        Iterator<Span> instances = oldLabels.instanceIterator(oldType);
        while (instances.hasNext()) {
            Span currInstance = instances.next();
            Span newSpan = this.tbManager.getMatchingSpan(currInstance, importLevel, this.getCurrentLevel());
            currLabels.addToType(newSpan, newType);
        }
    }

    private void evaluate(Statement statement) {
        log.info("Evaluating: " + statement);
        long start = System.currentTimeMillis();
        MonotonicTextLabels labels = this.getCurrentLabels();
        int statementType = statement.getStatementType();
        String keyword = statement.getKeyword();
        List<String> filesToLoad = statement.getFilesToLoad();
        String fileToLoad = statement.getFileToLoad();
        String type = statement.getType();
        boolean ignoreCase = statement.getIgnoreCase();
        Set<String> wordSet = statement.getWordSet();
        String split = statement.getSplit();
        String patt = statement.getPatt();
        String level = statement.getLevel();
        String oldType = statement.getOldType();
        String importType = statement.getImportType();
        String importLevel = statement.getImportLevel();
        String annotationType = statement.getAnnotationType();
        String startType = statement.getStartType();
        Mixup mixupExpr = statement.getMixupExpr();
        List<String> phraseList = statement.getPhraseList();
        String regex = statement.getRegex();
        int regexGroup = statement.getRegexGroup();
        if ("defDict".equals(keyword)) {
            if (filesToLoad.size() > 0) {
                labels.defineDictionary(type, filesToLoad, ignoreCase);
                filesToLoad.clear();
            } else {
                log.debug("defining dictionary of: " + wordSet);
                labels.defineDictionary(type, wordSet);
            }
        } else if ("defLevel".equals(keyword)) {
            this.createLevel(type, split, patt);
        } else if ("onLevel".equals(keyword)) {
            this.onLevel(level);
        } else if ("offLevel".equals(keyword)) {
            this.offLevel(level);
        } else if ("importFromLevel".equals(keyword)) {
            this.importLabelsFromLevel(importLevel, oldType, importType);
        } else if ("declareSpanType".equals(keyword)) {
            labels.declareType(type);
        } else if (statementType == Statement.PROVIDE) {
            labels.setAnnotatedBy(annotationType);
        } else if (statementType == Statement.REQUIRE) {
            labels.require(annotationType, fileToLoad);
        } else if (statementType == Statement.ANNOTATE_WITH) {
            labels.annotateWith(fileToLoad.substring(0, fileToLoad.length() - 4), fileToLoad);
        } else {
            Iterator<Span> input = null;
            if ("top".equals(startType)) {
                input = labels.getTextBase().documentSpanIterator();
            } else if (labels.isType(startType)) {
                input = labels.instanceIterator(startType);
            } else {
                throw new IllegalStateException("no type '" + startType + "' defined");
            }
            if (statementType == Statement.MIXUP) {
                Iterator<Span> i = mixupExpr.extract(labels, input);
                while (i.hasNext()) {
                    Span span = i.next();
                    this.extendLabels(labels, span, statement);
                }
                if ("defSpanType".equals(keyword)) {
                    labels.declareType(type);
                }
            } else if (statementType == Statement.FILTER) {
                TreeSet<Span> accum = new TreeSet<Span>();
                Iterator<Span> i = input;
                while (i.hasNext()) {
                    Span span = i.next();
                    if (this.hasExtraction(mixupExpr, labels, span)) continue;
                    accum.add(span);
                }
                i = accum.iterator();
                while (i.hasNext()) {
                    this.extendLabels(labels, i.next(), statement);
                }
            } else if (statementType == Statement.TRIE) {
                labels.defineTrie(phraseList);
                while (input.hasNext()) {
                    Span span = input.next();
                    Trie.ResultIterator output = labels.getTrie().lookup(span);
                    while (output.hasNext()) {
                        this.extendLabels(labels, (Span)output.next(), statement);
                    }
                }
            } else if (statementType == Statement.REGEX) {
                Pattern pattern = Pattern.compile(regex);
                while (input.hasNext()) {
                    Span span = input.next();
                    Matcher matcher = pattern.matcher(span.getDocumentContents());
                    while (matcher.find()) {
                        try {
                            Span subspan = span.charIndexProperSubSpan(matcher.start(regexGroup), matcher.end(regexGroup));
                            this.extendLabels(labels, subspan, statement);
                        }
                        catch (IllegalArgumentException ex) {}
                    }
                }
            } else {
                throw new IllegalStateException("illegal statement type " + statementType);
            }
        }
        long end = System.currentTimeMillis();
        log.info("time: " + (double)(end - start) / 1000.0 + " sec");
    }

    private boolean hasExtraction(Mixup mixupExpr, TextLabels labels, Span span) {
        Iterator<Span> input = Collections.singleton(span).iterator();
        Iterator<Span> output = mixupExpr.extract(labels, input);
        return output.hasNext();
    }

    private void extendLabels(MonotonicTextLabels labels, Span span, Statement statement) {
        String keyword = statement.getKeyword();
        String type = statement.getType();
        String property = statement.getProperty();
        String value = statement.getValue();
        if ("defSpanType".equals(keyword)) {
            labels.addToType(span, type);
        } else if ("defSpanProp".equals(keyword)) {
            labels.setProperty(span, property, value);
        } else if ("defTokenProp".equals(keyword)) {
            for (int j = 0; j < span.size(); ++j) {
                TextToken token = span.getTextToken(j);
                if (property == null) {
                    throw new IllegalStateException("null property");
                }
                labels.setProperty(token, property, value);
            }
        }
    }
}

