/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.ui;

import bsh.EvalError;
import bsh.Interpreter;
import edu.cmu.minorthird.classify.BasicDataset;
import edu.cmu.minorthird.classify.BatchVersion;
import edu.cmu.minorthird.classify.ClassLabel;
import edu.cmu.minorthird.classify.ClassifierLearner;
import edu.cmu.minorthird.classify.Dataset;
import edu.cmu.minorthird.classify.Example;
import edu.cmu.minorthird.classify.Splitter;
import edu.cmu.minorthird.classify.experiments.CrossValSplitter;
import edu.cmu.minorthird.classify.experiments.RandomSplitter;
import edu.cmu.minorthird.classify.multi.MultiClassLabel;
import edu.cmu.minorthird.classify.multi.MultiDataset;
import edu.cmu.minorthird.classify.multi.MultiExample;
import edu.cmu.minorthird.classify.sequential.SequenceClassifierLearner;
import edu.cmu.minorthird.classify.sequential.SequenceDataset;
import edu.cmu.minorthird.text.EncapsulatingAnnotatorLoader;
import edu.cmu.minorthird.text.FancyLoader;
import edu.cmu.minorthird.text.MonotonicTextLabels;
import edu.cmu.minorthird.text.MutableTextLabels;
import edu.cmu.minorthird.text.NestedTextLabels;
import edu.cmu.minorthird.text.Span;
import edu.cmu.minorthird.text.TextBase;
import edu.cmu.minorthird.text.TextLabels;
import edu.cmu.minorthird.text.TextLabelsLoader;
import edu.cmu.minorthird.text.Token;
import edu.cmu.minorthird.text.learn.AnnotatorLearner;
import edu.cmu.minorthird.text.learn.MixupCompatible;
import edu.cmu.minorthird.text.learn.SpanFeatureExtractor;
import edu.cmu.minorthird.text.mixup.MixupInterpreter;
import edu.cmu.minorthird.text.mixup.MixupProgram;
import edu.cmu.minorthird.ui.Recommended;
import edu.cmu.minorthird.util.BasicCommandLineProcessor;
import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.ProgressCounter;
import edu.cmu.minorthird.util.RefUtils;
import edu.cmu.minorthird.util.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineUtil {
    private static Logger log = Logger.getLogger(CommandLineUtil.class);
    private static final String CANT_SET_ME = "can't set";

    private static String safeGetRequiredAnnotation(SpanFeatureExtractor fe) {
        if (fe instanceof MixupCompatible) {
            String s = ((MixupCompatible)((Object)fe)).getRequiredAnnotation();
            return s == null ? "" : s;
        }
        return CANT_SET_ME;
    }

    protected static void safeSetRequiredAnnotation(SpanFeatureExtractor fe, String s) {
        if ("".equals(s) || CANT_SET_ME.equals(s)) {
            return;
        }
        if (fe instanceof MixupCompatible) {
            ((MixupCompatible)((Object)fe)).setRequiredAnnotation(s);
        } else {
            log.error("feature extractor is not MixupCompatible: " + fe);
        }
    }

    private static void safeSetAnnotatorLoader(SpanFeatureExtractor fe, String s) {
        if (!(fe instanceof MixupCompatible)) {
            log.error("fe is not MixupCompatible: " + fe);
        } else {
            try {
                ((MixupCompatible)((Object)fe)).setAnnotatorLoader(new EncapsulatingAnnotatorLoader(s));
            }
            catch (Exception e) {
                log.error("can't set AnnotatorLoader: " + e);
            }
        }
    }

    public static SequenceDataset toSequenceDataset(TextLabels labels, SpanFeatureExtractor fe, int historySize, String tokenProp) {
        NestedTextLabels safeLabels = new NestedTextLabels(labels);
        safeLabels.shadowProperty(tokenProp);
        SequenceDataset seqData = new SequenceDataset();
        seqData.setHistorySize(historySize);
        Iterator<Span> j = labels.getTextBase().documentSpanIterator();
        while (j.hasNext()) {
            Span document = j.next();
            Example[] sequence = new Example[document.size()];
            for (int i = 0; i < document.size(); ++i) {
                Example example;
                Token tok = document.getToken(i);
                String value = labels.getProperty(tok, tokenProp);
                if (value == null) {
                    value = "NONE";
                }
                Span tokenSpan = document.subSpan(i, 1);
                sequence[i] = example = new Example(fe.extractInstance(safeLabels, tokenSpan), new ClassLabel(value));
            }
            seqData.addSequence(sequence);
        }
        return seqData;
    }

    public static Dataset toDataset(TextLabels textLabels, SpanFeatureExtractor fe, String spanProp, String spanType) {
        return CommandLineUtil.toDataset(textLabels, fe, spanProp, spanType, null);
    }

    public static Dataset toSeqDataset(TextLabels textLabels, SpanFeatureExtractor fe, String spanProp, String spanType) {
        NestedTextLabels safeLabels = new NestedTextLabels(textLabels);
        safeLabels.shadowProperty(spanProp);
        Iterator<Span> candidateLooper = textLabels.getTextBase().documentSpanIterator();
        if (spanType.equals("combined")) {
            BasicDataset seqDataset = new BasicDataset();
            int counter = 0;
            Iterator<Span> i = candidateLooper;
            while (i.hasNext()) {
                Span s = i.next();
                System.out.println("Span1 Document ID: " + s.getDocumentId() + "  Counter: " + counter);
                Set<String> types2 = textLabels.getTypes();
                for (String type : types2) {
                    int classLabel1 = textLabels.hasType(s, type) ? 1 : -1;
                    if (classLabel1 <= 0) continue;
                    seqDataset.add(new Example(fe.extractInstance(safeLabels, s), ClassLabel.multiLabel(type, classLabel1)));
                }
                ++counter;
            }
            return seqDataset;
        }
        throw new IllegalArgumentException("either spanProp or spanType must be specified");
    }

    public static Dataset toDataset(TextLabels textLabels, SpanFeatureExtractor fe, String spanProp, String spanType, String candidateType) {
        Iterator<Span> candidateLooper;
        HashMap<String, Integer> countByClass = new HashMap<String, Integer>();
        NestedTextLabels safeLabels = new NestedTextLabels(textLabels);
        safeLabels.shadowProperty(spanProp);
        Iterator<Span> iterator = candidateLooper = candidateType != null ? textLabels.instanceIterator(candidateType) : textLabels.getTextBase().documentSpanIterator();
        if (spanType != null) {
            BasicDataset dataset = new BasicDataset();
            Iterator<Span> i = candidateLooper;
            while (i.hasNext()) {
                Span s = i.next();
                int classLabel = textLabels.hasType(s, spanType) ? 1 : -1;
                String className = classLabel < 0 ? "NEG" : "POS";
                dataset.add(new Example(fe.extractInstance(safeLabels, s), ClassLabel.binaryLabel(classLabel)));
                Integer cnt = (Integer)countByClass.get(className);
                if (cnt == null) {
                    countByClass.put(className, new Integer(1));
                    continue;
                }
                countByClass.put(className, new Integer(cnt + 1));
            }
            System.out.println("Number of examples by class: " + countByClass);
            return dataset;
        }
        if (spanProp != null) {
            BasicDataset dataset = new BasicDataset();
            Iterator<Span> i = candidateLooper;
            while (i.hasNext()) {
                Span s = i.next();
                String className = textLabels.getProperty(s, spanProp);
                if (className == null) {
                    dataset.add(new Example(fe.extractInstance(safeLabels, s), new ClassLabel("NEG")));
                } else {
                    dataset.add(new Example(fe.extractInstance(safeLabels, s), new ClassLabel(className)));
                }
                Integer cnt = (Integer)countByClass.get(className);
                if (cnt == null) {
                    countByClass.put(className, new Integer(1));
                    continue;
                }
                countByClass.put(className, new Integer(cnt + 1));
            }
            System.out.println("Number of examples by class: " + countByClass);
            return dataset;
        }
        throw new IllegalArgumentException("either spanProp or spanType must be specified");
    }

    public static MultiDataset toMultiDataset(MonotonicTextLabels textLabels, SpanFeatureExtractor fe, String[] multiSpanProp) {
        HashMap<String, Integer> countByClass = new HashMap<String, Integer>();
        NestedTextLabels safeLabels = new NestedTextLabels(textLabels);
        if (multiSpanProp != null) {
            MultiDataset dataset = new MultiDataset();
            Iterator<Span> i = textLabels.getTextBase().documentSpanIterator();
            while (i.hasNext()) {
                Span s = i.next();
                String[] classNames = new String[multiSpanProp.length];
                ClassLabel[] classLabels = new ClassLabel[multiSpanProp.length];
                for (int j = 0; j < multiSpanProp.length; ++j) {
                    String spanProp = multiSpanProp[j];
                    classNames[j] = textLabels.getProperty(s, spanProp);
                    classLabels[j] = classNames[j] == null ? new ClassLabel("NEG") : new ClassLabel(classNames[j]);
                    Integer cnt = (Integer)countByClass.get(classNames[j]);
                    if (cnt == null) {
                        countByClass.put(classNames[j], new Integer(1));
                        continue;
                    }
                    countByClass.put(classNames[j], new Integer(cnt + 1));
                }
                dataset.addMulti(new MultiExample(fe.extractInstance(safeLabels, s), new MultiClassLabel(classLabels)));
            }
            return dataset;
        }
        throw new IllegalArgumentException("either spanProp or spanType must be specified");
    }

    public static Object newObjectFromBSH(String s, Class<?> expectedType) {
        try {
            Object o;
            Interpreter interp = new Interpreter();
            interp.eval("import edu.cmu.minorthird.classify.*;");
            interp.eval("import edu.cmu.minorthird.classify.experiments.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.linear.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.trees.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.knn.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.svm.*;");
            interp.eval("import edu.cmu.minorthird.classify.transform.*;");
            interp.eval("import edu.cmu.minorthird.classify.sequential.*;");
            interp.eval("import edu.cmu.minorthird.text.learn.*;");
            interp.eval("import edu.cmu.minorthird.text.*;");
            interp.eval("import edu.cmu.minorthird.ui.*;");
            interp.eval("import edu.cmu.minorthird.util.*;");
            if (!s.startsWith("new") && !s.startsWith("bsh.source")) {
                s = "new " + s;
            }
            if (!expectedType.isInstance(o = interp.eval(s))) {
                throw new IllegalArgumentException(s + " did not produce " + expectedType);
            }
            return o;
        }
        catch (EvalError e) {
            log.error(e.toString());
            throw new IllegalArgumentException("error parsing '" + s + "':\n" + e);
        }
    }

    static Object newObjectFromBSH(String s) {
        try {
            Interpreter interp = new Interpreter();
            interp.eval("import edu.cmu.minorthird.classify.*;");
            interp.eval("import edu.cmu.minorthird.classify.experiments.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.linear.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.trees.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.knn.*;");
            interp.eval("import edu.cmu.minorthird.classify.algorithms.svm.*;");
            interp.eval("import edu.cmu.minorthird.classify.transform.*;");
            interp.eval("import edu.cmu.minorthird.classify.sequential.*;");
            interp.eval("import edu.cmu.minorthird.text.learn.*;");
            interp.eval("import edu.cmu.minorthird.text.*;");
            interp.eval("import edu.cmu.minorthird.ui.*;");
            if (!s.startsWith("new") && !s.startsWith("bsh.source")) {
                s = "new " + s;
            }
            Object o = interp.eval(s);
            return o;
        }
        catch (EvalError e) {
            log.error(e.toString());
            throw new IllegalArgumentException("error parsing '" + s + "':\n" + e);
        }
    }

    static Splitter toSplitter(String splitterName) {
        if (splitterName.charAt(0) == 'k') {
            int folds = StringUtil.atoi(splitterName.substring(1, splitterName.length()));
            return new CrossValSplitter(folds);
        }
        if (splitterName.charAt(0) == 'r') {
            double pct = (double)StringUtil.atoi(splitterName.substring(1, splitterName.length())) / 100.0;
            return new RandomSplitter(pct);
        }
        if ("-help".equals(splitterName)) {
            System.out.println("Valid splitter names:");
            System.out.println(" kN              N-fold cross-validation, e.g. k5 is 5-CV");
            System.out.println(" rNN             single random train-test split with NN% going to train");
            System.out.println("                 e.g, r70 is a 70%-30% split");
            System.out.println(" other           anything else is interpreted as bean shell script");
            return new RandomSplitter(0.7);
        }
        return (Splitter)CommandLineUtil.newObjectFromBSH(splitterName, Splitter.class);
    }

    public static String createSpanProp(String spanTypes, MonotonicTextLabels labels) {
        if (spanTypes.indexOf(",") == -1) {
            return spanTypes;
        }
        String createSpanPropMixup = "";
        createSpanPropMixup = createSpanPropMixup + "provide createSpanPropMixup;\n";
        String property = new String("_property");
        int catIndex = spanTypes.indexOf(":");
        if (catIndex > -1) {
            property = spanTypes.substring(0, catIndex);
        }
        String[] types2 = spanTypes.substring(catIndex + 1, spanTypes.length()).split(",");
        for (int i = 0; i < types2.length; ++i) {
            Iterator<Span> sl = labels.instanceIterator(types2[i]);
            while (sl.hasNext()) {
                createSpanPropMixup = createSpanPropMixup + "defSpanProp " + property + ":" + types2[i] + "=: ... [@" + types2[i] + "] ...;\n";
            }
        }
        try {
            MixupProgram prog = new MixupProgram(createSpanPropMixup);
            MixupInterpreter interpreter = new MixupInterpreter(prog);
            interpreter.eval(labels);
            return property;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String[] createMultiSpanProp(File multiSpanProps, MonotonicTextLabels labels) throws Exception {
        ProgressCounter pc = new ProgressCounter("loading file " + multiSpanProps.getName(), "line");
        LineNumberReader in = null;
        try {
            in = new LineNumberReader(new FileReader(multiSpanProps));
        }
        catch (Exception e) {
            System.out.println("Cannot open multiSpanProp file");
            e.printStackTrace();
        }
        ArrayList<String> spanPropList = new ArrayList<String>();
        if (in != null) {
            String line;
            while ((line = in.readLine()) != null) {
                spanPropList.add(CommandLineUtil.createSpanProp(line, labels));
                pc.progress();
            }
            String[] spanProps = spanPropList.toArray(new String[0]);
            return spanProps;
        }
        return null;
    }

    public static class ViewLabelsParams
    extends BasicCommandLineProcessor {
        public void toXML(String key) {
            System.out.println("Creating XML documents");
            try {
                MutableTextLabels labels = (MutableTextLabels)FancyLoader.loadTextLabels(key);
                TextBase base = labels.getTextBase();
                TextLabelsLoader x = new TextLabelsLoader();
                Iterator<Span> i = base.documentSpanIterator();
                while (i.hasNext()) {
                    String doc = i.next().getDocumentId();
                    String str = x.createXMLmarkup(doc, labels);
                    System.out.println(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("something wrong....");
                System.exit(1);
            }
        }

        public void usage() {
            System.out.println("labels output parameters:");
            System.out.println(" -toXML DIRECTORY_NAME    create documents with embedded XML tags and put in directory");
            System.out.println();
        }
    }

    public static class AnnotatorOutputParams
    extends BasicCommandLineProcessor {
        private static final String[] ALLOWED_VALUES = new String[]{"minorthird", "xml", "strings"};
        public String format = "minorthird";
        private String formatHelp = new String("output results in format TYPE (either 'minorthird', 'xml', or 'strings'");

        public void format(String s) {
            this.format = s;
        }

        public void usage() {
            System.out.println("annotation output parameters:");
            System.out.println(" -format TYPE             " + this.formatHelp);
            System.out.println();
        }

        public String getOutputFormat() {
            return this.format;
        }

        public void setOutputFormat(String s) {
            this.format = s;
        }

        public String[] getAllowedOutputFormatValues() {
            return ALLOWED_VALUES;
        }

        public String getOutputFormatHelp() {
            return this.formatHelp;
        }
    }

    public static class MixupParams
    extends BasicCommandLineProcessor {
        public String fileName = null;
        private String mixupHelp = new String("run mixup program in FILE (existing file, or name on classpath)");

        public void mixup(String s) {
            this.fileName = s;
        }

        public void usage() {
            System.out.println("mixup program parameters:");
            System.out.println(" -mixup FILE              run mixup program in FILE (existing file, or name on classpath)");
            System.out.println();
        }

        public String getMixupProgramFilename() {
            return this.fileName;
        }

        public void setMixupProgramFilename(String s) {
            this.mixup(s);
        }

        public String getMixupHelp() {
            return this.mixupHelp;
        }
    }

    public static class TrainTaggerParams
    extends BasicCommandLineProcessor {
        public SequenceClassifierLearner learner = new Recommended.VPTagLearner();
        public SpanFeatureExtractor fe = new Recommended.TokenFE();
        public String output = "_prediction";
        public boolean showData = false;
        private String learnerHelp = new String("Bean-shell code to create a ClassifierLearner\n - default is \"new Recommended.NaiveBayes()\"");
        private String showDataHelp = new String("interactively view the constructed training dataset");
        private String feHelp = new String("Bean-shell code to create a SpanFeatureExtractor\n - default is \"new Recommended.DocumentFE()\" ");
        private String outputHelp = new String("the type or property that is produced by the learned\n ClassifierAnnotator - default is \"_prediction\"");

        public void showData() {
            this.showData = true;
        }

        public void learner(String s) {
            this.learner = (SequenceClassifierLearner)CommandLineUtil.newObjectFromBSH(s, SequenceClassifierLearner.class);
        }

        public void output(String s) {
            this.output = s;
        }

        public CommandLineProcessor fe(String s) {
            this.fe = (SpanFeatureExtractor)CommandLineUtil.newObjectFromBSH(s, SpanFeatureExtractor.class);
            if (this.fe instanceof CommandLineProcessor.Configurable) {
                return ((CommandLineProcessor.Configurable)((Object)this.fe)).getCLP();
            }
            return null;
        }

        public void usage() {
            System.out.println("tagger training parameters:");
            System.out.println(" [-learner BSH]           Bean-shell code to create an SequenceClassifierLearner ");
            System.out.println(" [-showData]              interactively view the constructed training dataset");
            System.out.println(" [-fe FE]                 Bean-shell code to create a SpanFeatureExtractor");
            System.out.println("                          - default is \"new Recommended.TokenFE()\"");
            System.out.println("                          - if FE implements CommandLineProcessor.Configurable then");
            System.out.println("                            immed. following command-line arguments are passed to it");
            System.out.println(" [-output STRING]         the type or property that is produced by the learned");
            System.out.println("                            Annotator - default is \"_prediction\"");
            System.out.println();
        }

        public SequenceClassifierLearner getLearner() {
            return this.learner;
        }

        public void setLearner(SequenceClassifierLearner learner) {
            this.learner = learner;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String s) {
            this.output = s;
        }

        public SpanFeatureExtractor getFeatureExtractor() {
            return this.fe;
        }

        public void setFeatureExtractor(SpanFeatureExtractor fe) {
            this.fe = fe;
        }

        public boolean getShowData() {
            return this.showData;
        }

        public void setShowData(boolean flag) {
            this.showData = flag;
        }

        public String getLearnerHelp() {
            return this.learnerHelp;
        }

        public String getShowDataHelp() {
            return this.showDataHelp;
        }

        public String getFeHelp() {
            return this.feHelp;
        }

        public String getOutputHelp() {
            return this.outputHelp;
        }
    }

    public static class TrainExtractorParams
    extends BasicCommandLineProcessor {
        public AnnotatorLearner learner = new Recommended.VPHMMLearner();
        public SpanFeatureExtractor fe = null;
        public String mixup = null;
        private String embeddedAnnotators = "";
        public String output = "_prediction";
        private String learnerHelp = new String("Bean-shell code to create a ClassifierLearner\n - default is \"new Recommended.NaiveBayes()\"");
        private String mixupHelp = new String("run named mixup code before extracting features");
        private String embedHelp = new String("embed the listed annotators in the feature extractor");
        private String outputHelp = new String("the type or property that is produced by the learned\n ClassifierAnnotator - default is \"_prediction\"");

        public void learner(String s) {
            this.learner = (AnnotatorLearner)CommandLineUtil.newObjectFromBSH(s, AnnotatorLearner.class);
            if (this.fe != null) {
                this.learner.setSpanFeatureExtractor(this.fe);
            }
        }

        public void output(String s) {
            this.output = s;
        }

        public void other(String s) {
            TrainExtractorParams o = this;
            RefUtils.modify(o, s);
        }

        public void option(String s) {
            TrainExtractorParams o = this;
            RefUtils.modify(o, s);
        }

        public void learnerOp(String s) {
            AnnotatorLearner o = this.learner;
            RefUtils.modify(o, s);
        }

        public void feOp(String s) {
            if (this.fe != null) {
                SpanFeatureExtractor o = this.fe;
                RefUtils.modify(o, s);
            } else {
                System.out.println("You must define a Feature Extrator before setting it's options");
            }
        }

        public void mixup(String s) {
            this.mixup = s;
            if (this.fe == null) {
                this.fe = this.learner.getSpanFeatureExtractor();
            }
            CommandLineUtil.safeSetRequiredAnnotation(this.fe, s);
        }

        public void embed(String s) {
            if (this.fe == null) {
                this.fe = this.learner.getSpanFeatureExtractor();
            }
            this.embeddedAnnotators = s;
            CommandLineUtil.safeSetAnnotatorLoader(this.fe, s);
        }

        public CommandLineProcessor fe(String s) {
            this.fe = (SpanFeatureExtractor)CommandLineUtil.newObjectFromBSH(s, SpanFeatureExtractor.class);
            if (this.learner != null) {
                this.learner.setSpanFeatureExtractor(this.fe);
            }
            if (this.fe instanceof CommandLineProcessor.Configurable) {
                return ((CommandLineProcessor.Configurable)((Object)this.fe)).getCLP();
            }
            return null;
        }

        public void usage() {
            System.out.println("extraction training parameters:");
            System.out.println(" [-learner BSH]           Bean-shell code to create an AnnotatorLearner ");
            System.out.println(" [-fe FE]                 Bean-shell code to create a SpanFeatureExtractor");
            System.out.println("                          - default is \"new Recommended.TokenFE()\"");
            System.out.println("                          - if FE implements CommandLineProcessor.Configurable then");
            System.out.println("                            immediately following arguments are passed to it");
            System.out.println(" [-mixup STRING]          run named mixup code before extracting features");
            System.out.println(" [-embed STRING]          embed the listed annotators in the feature extractor");
            System.out.println(" [-output STRING]         the type or property that is produced by the learned");
            System.out.println("                           Annotator - default is \"_prediction\"");
            System.out.println(" [-learnerOp STRING=VALUE] Extra options that can be defined with the learner");
            System.out.println("                           - defaults are set");
            System.out.println("                           - ex: displayDatasetBeforeLearning=true");
            System.out.println(" [-feOp STRING=VALUE]      Extra options that can be defined with the feature extractor");
            System.out.println("                           - defaults are set");
            System.out.println("                           - ex: featureWindowSize=4");
            System.out.println();
        }

        public AnnotatorLearner getLearner() {
            return this.learner;
        }

        public void setLearner(AnnotatorLearner learner) {
            this.learner = learner;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String s) {
            this.output = s;
        }

        public String getMixup() {
            if (this.fe == null) {
                this.fe = this.learner.getSpanFeatureExtractor();
            }
            return CommandLineUtil.safeGetRequiredAnnotation(this.fe);
        }

        public void setMixup(String s) {
            if (this.fe == null) {
                this.fe = this.learner.getSpanFeatureExtractor();
            }
            CommandLineUtil.safeSetRequiredAnnotation(this.fe, s);
        }

        public String getEmbeddedAnnotators() {
            return this.embeddedAnnotators;
        }

        public void setEmbeddedAnnotators(String s) {
            if (this.fe == null) {
                this.fe = this.learner.getSpanFeatureExtractor();
            }
            this.embeddedAnnotators = s;
            CommandLineUtil.safeSetAnnotatorLoader(this.fe, s);
        }

        public String getLearnerHelp() {
            return this.learnerHelp;
        }

        public String getMixupHelp() {
            return this.mixupHelp;
        }

        public String getEmbeddedAnnotatorsHelp() {
            return this.embedHelp;
        }

        public String getOutputHelp() {
            return this.outputHelp;
        }
    }

    public static class TaggerSignalParams
    extends BasicCommandLineProcessor {
        private BaseParams base = new BaseParams();
        public String tokenProp = null;
        private String tokenPropHelp = new String("create a sequential dataset, where tokens are\n given the class associated with this token property");

        public TaggerSignalParams() {
        }

        public TaggerSignalParams(BaseParams base) {
            this.base = base;
        }

        public void tokenProp(String s) {
            this.tokenProp = s;
        }

        public void usage() {
            System.out.println("tagger 'signal' parameters:");
            System.out.println(" -tokenProp TYPE          " + this.tokenPropHelp);
            System.out.println();
        }

        public String getTokenProp() {
            return this.tokenProp == null ? "n/a" : this.tokenProp;
        }

        public void setTokenProp(String t) {
            this.tokenProp = "n/a".equals(t) ? null : t;
        }

        public Object[] getAllowedTokenPropValues() {
            return this.base.labels == null ? new String[]{} : this.base.labels.getTokenProperties().toArray();
        }

        public String getTokenPropHelp() {
            return this.tokenPropHelp;
        }
    }

    public static class MultiClassificationSignalParams
    extends BasicCommandLineProcessor {
        private BaseParams base = new BaseParams();
        public File multiSpanPropFile;
        public String multiSpanPropFileName;
        public String[] multiSpanProp;
        public boolean cross = false;
        private String multiSpanPropFileHelp = new String("File that contains your definition of spanProperty\n -Format(1 spanProp per line): SPAN_PROP_NAME:SPAN_TYPE1,SPAN_TYP2,....");
        private String crossHelp = new String("Classify dataset and add the classification as features to each document");

        public MultiClassificationSignalParams() {
        }

        public MultiClassificationSignalParams(BaseParams base) {
            this.base = base;
            try {
                if (this.multiSpanPropFile != null) {
                    this.multiSpanProp = CommandLineUtil.createMultiSpanProp(this.multiSpanPropFile, this.base.labels);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void multiSpanPropFile(String s) {
            File f;
            this.multiSpanPropFileName = s;
            this.multiSpanPropFile = f = new File(s);
            try {
                this.multiSpanProp = CommandLineUtil.createMultiSpanProp(f, this.base.labels);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void cross() {
            this.cross = true;
        }

        public void usage() {
            System.out.println("multi class classification 'signal' parameters:");
            System.out.println(" -multSpanProp FILE             " + this.multiSpanPropFileHelp);
            System.out.println(" -cross                         " + this.crossHelp);
            System.out.println("");
        }

        public String getMultiSpanPropFile() {
            return this.multiSpanPropFileName;
        }

        public void setMultiSpanPropFile(String s) {
            File f;
            this.multiSpanPropFileName = s;
            this.multiSpanPropFile = f = new File(s);
            try {
                this.multiSpanProp = CommandLineUtil.createMultiSpanProp(this.multiSpanPropFile, this.base.labels);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean getCross() {
            return this.cross;
        }

        public void setCross(boolean b) {
            this.cross = b;
        }

        public String getMultiSpanPropFileHelp() {
            return this.multiSpanPropFileHelp;
        }

        public String getCrossHelp() {
            return this.crossHelp;
        }
    }

    public static class ExtractionSignalParams
    extends BasicCommandLineProcessor {
        private BaseParams base = new BaseParams();
        protected String spanPropString = null;
        public String spanType = null;
        public String spanProp = null;
        private String spanTypeHelp = new String("learn how to extract the given TYPE");
        private String spanPropHelp = new String("learn how to extract spans with the given property\n and label them with the given property");

        public ExtractionSignalParams() {
        }

        public ExtractionSignalParams(BaseParams base) {
            this.base = base;
            if (this.spanPropString != null) {
                this.spanProp = CommandLineUtil.createSpanProp(this.spanPropString, this.base.labels);
            }
        }

        public void spanType(String s) {
            this.spanType = s;
        }

        public void spanProp(String s) {
            if (s.indexOf(44) == -1) {
                this.spanProp = s;
            } else {
                this.spanPropString = s;
                if (this.base.labels != null) {
                    this.spanProp = CommandLineUtil.createSpanProp(this.spanPropString, this.base.labels);
                }
            }
        }

        public void usage() {
            System.out.println("extraction 'signal' parameters:");
            System.out.println(" -spanType TYPE           " + this.spanTypeHelp);
            System.out.println(" -spanProp PROP           " + this.spanPropHelp);
            System.out.println(" -spanProp PROPERTY:SpanType1,SpanType2");
            System.out.println("                          learn how to extract spans with the named property and span types");
            System.out.println("                          and label them with the name property");
        }

        public String getSpanType() {
            return this.safeGet(this.spanType, "n/a");
        }

        public void setSpanType(String t) {
            this.spanType = this.safePut(t, "n/a");
        }

        public String getSpanProp() {
            return this.safeGet(this.spanProp, "n/a");
        }

        public void setSpanProp(String p) {
            this.spanProp = this.safePut(p, "n/a");
        }

        public Object[] getAllowedSpanTypeValues() {
            return this.base.labels == null ? new String[]{} : this.base.labels.getTypes().toArray();
        }

        public Object[] getAllowedSpanPropValues() {
            return this.base.labels == null ? new String[]{} : this.base.labels.getSpanProperties().toArray();
        }

        protected String safeGet(String s, String def) {
            return s == null ? def : s;
        }

        protected String safePut(String s, String def) {
            return def.equals(s) ? null : s;
        }

        public String getSpanTypeHelp() {
            return this.spanTypeHelp;
        }

        public String getSpanPropHelp() {
            return this.spanPropHelp;
        }
    }

    public static class SplitterParams
    extends BasicCommandLineProcessor {
        public Splitter splitter = new RandomSplitter(0.7);
        public MonotonicTextLabels labels = null;
        public boolean showTestDetails = true;
        private String repositoryKey = "";
        private String splitterHelp = new String("The Splitter you would like to use to divide your training and testing data");
        private String showTestDetailsHelp = new String("visualize test examples along with evaluation");
        private String testHelp = new String("Specify directory or repository key of test data\n  -Note: splitter will be ignored with this option");

        public void splitter(String s) {
            this.splitter = CommandLineUtil.toSplitter(s);
        }

        public void showTestDetails(String bool) {
            this.showTestDetails = new Boolean(bool);
        }

        public void test(String s) {
            this.repositoryKey = s;
            this.labels = (MonotonicTextLabels)FancyLoader.loadTextLabels(this.repositoryKey);
        }

        public void SplitterOp(String s) {
            Splitter o = this.splitter;
            RefUtils.modify(o, s);
        }

        public void usage() {
            System.out.println("train/test experimentation parameters:");
            System.out.println(" -splitter SPLITTER               specify splitter, e.g. -k5, -s10, -r70");
            System.out.println("                                  - At most one of -splitter, -test should be specified.");
            System.out.println("                                  - The default splitter is r70.");
            System.out.println(" [-showTestDetails true|false]    " + this.showTestDetailsHelp);
            System.out.println(" -test REPOSITORY_KEY             specify source for test data");
            System.out.println(" [-SplitterOp STRING=VALUE]       Extra options that can be defined with the splitter");
            System.out.println("                                  - ex: trainFraction=.07");
            System.out.println();
        }

        public String getTestFilename() {
            return this.repositoryKey;
        }

        public void setTestFilename(String name) {
            if (name.endsWith(".labels")) {
                this.test(name.substring(0, name.length() - ".labels".length()));
            } else {
                this.test(name);
            }
        }

        public String getTestKey() {
            return this.repositoryKey;
        }

        public void setTestKey(String key) {
            this.test(key);
        }

        public Object[] getAllowedTestKeyValues() {
            return FancyLoader.getPossibleTextLabelKeys();
        }

        public Splitter getSplitter() {
            return this.splitter;
        }

        public void setSplitter(Splitter splitter) {
            this.splitter = splitter;
        }

        public boolean getShowTestDetails() {
            return this.showTestDetails;
        }

        public void setShowTestDetails(boolean flag) {
            this.showTestDetails = flag;
        }

        public String getSplitterHelp() {
            return this.splitterHelp;
        }

        public String getShowTestDetailsHelp() {
            return this.showTestDetailsHelp;
        }

        public String getTestFilenameHelp() {
            return this.testHelp;
        }
    }

    public static class OnlineLearnerParams
    extends BasicCommandLineProcessor {
        public MutableTextLabels data = null;
        public MonotonicTextLabels labels = null;
        public String repositoryKey = null;
        public boolean experiment = false;
        public File loadFrom;
        private String loadFromName;

        public void loadFrom(String s) {
            this.loadFrom = new File(s);
            this.loadFromName = s;
        }

        public void data(String dirName) {
            this.repositoryKey = dirName;
            this.data = (MutableTextLabels)FancyLoader.loadTextLabels(dirName);
            this.labels = (MonotonicTextLabels)FancyLoader.loadTextLabels(dirName);
        }

        public void experiment() {
            this.experiment = true;
        }

        public void usage() {
            System.out.println("Online Learning loading parameters:");
            System.out.println(" -loadFrom FILE           file containing serialized Annotator");
            System.out.println(" -data DIRECTORY        Directory containing new data you would like to add");
            System.out.println(" -experiment            Perform an experiment with labeled data -");
            System.out.println("                        See if Online Learning give you an advantage");
            System.out.println();
        }

        public String getLoadFrom() {
            return this.loadFromName;
        }

        public void setLoadFrom(String s) {
            this.loadFrom(s);
        }

        public String getLabelsFilename() {
            return this.repositoryKey;
        }

        public void setLabelsFilename(String name) {
            if (name.endsWith(".labels")) {
                this.data(name.substring(0, name.length() - ".labels".length()));
            } else {
                this.data(name);
            }
        }
    }

    public static class OnlineBaseParams
    extends BasicCommandLineProcessor {
        public MutableTextLabels labeledData = null;
        public String repositoryKey = "";
        public boolean showLabels = false;
        public boolean showResult = false;
        private String labeledDataHelp = new String("REPOSITORY_KEY or directory that contains labeledData");
        private String showLabelsHelp = new String("interactively view textBase loaded by -labels");
        private String showResultHelp = new String("interactively view final result of this operation");

        public void labeledData(String repositoryKey) {
            this.repositoryKey = repositoryKey;
            this.labeledData = (MutableTextLabels)FancyLoader.loadTextLabels(repositoryKey);
        }

        public void showLabels() {
            this.showLabels = true;
        }

        public void showResult() {
            this.showResult = true;
        }

        public void usage() {
            System.out.println("basic parameters:");
            System.out.println(" -labeledData                  " + this.labeledDataHelp);
            System.out.println(" [-showLabels]                 " + this.showLabelsHelp);
            System.out.println(" [-showResult]                 " + this.showResultHelp);
            System.out.println();
        }

        public String getLabelsFilename() {
            return this.repositoryKey;
        }

        public void setLabelsFilename(String name) {
            if (name.endsWith(".labels")) {
                this.labeledData(name.substring(0, name.length() - ".labels".length()));
            } else {
                this.labeledData(name);
            }
        }

        public String getRepositoryKey() {
            return this.repositoryKey;
        }

        public void setRepositoryKey(String key) {
            this.labeledData(key);
        }

        public Object[] getAllowedRepositoryKeyValues() {
            return FancyLoader.getPossibleTextLabelKeys();
        }

        public String getLabelsFilenameHelp() {
            return this.labeledDataHelp;
        }
    }

    public static class OnlineSignalParams
    extends BasicCommandLineProcessor {
        public String spanType = null;
        public String spanTypeHelp = new String("learn how to extract the given TYPE");

        public OnlineSignalParams() {
        }

        public OnlineSignalParams(OnlineBaseParams base) {
        }

        public void spanType(String s) {
            this.spanType = s;
        }

        public String getOutputType(String output) {
            return this.spanType == null ? null : output;
        }

        public void usage() {
            System.out.println("extraction 'signal' parameters:");
            System.out.println(" -spanType TYPE           " + this.spanTypeHelp);
        }

        public String getSpanType() {
            return this.spanType;
        }

        public void setSpanType(String t) {
            this.spanType = t;
        }

        public String getSpanTypeHelp() {
            return this.spanTypeHelp;
        }
    }

    public static class LoadAnnotatorParams
    extends BasicCommandLineProcessor {
        public File loadFrom;
        private String loadFromName;
        private String loadFromHelp = new String("file containing serialized Annotator");

        public void loadFrom(String s) {
            this.loadFrom = new File(s);
            this.loadFromName = s;
        }

        public void usage() {
            System.out.println("annotation loading parameters:");
            System.out.println(" -loadFrom FILE           " + this.loadFromHelp);
            System.out.println();
        }

        public String getLoadFrom() {
            return this.loadFromName;
        }

        public void setLoadFrom(String s) {
            this.loadFrom(s);
        }

        public String getLoadFromHelp() {
            return this.loadFromHelp;
        }
    }

    public static class TestExtractorParams
    extends LoadAnnotatorParams {
        public boolean showExtractor = false;

        public void showExtractor() {
            this.showExtractor = true;
        }

        public void usage() {
            System.out.println("extractor testing parameters:");
            System.out.println(" -loadFrom FILE           file holding serialized Annotator, learned by TrainExtractor.");
            System.out.println(" [-showExtractor]         interactively view the loaded extractor");
            System.out.println();
        }

        public boolean getShowExtractor() {
            return this.showExtractor;
        }

        public void setShowExtractor(boolean flag) {
            this.showExtractor = flag;
        }
    }

    public static class TestClassifierParams
    extends LoadAnnotatorParams {
        public boolean showClassifier = false;
        public boolean showData = false;
        public boolean showTestDetails = true;
        private String loadFromHelp = new String("file containing serialized ClassifierAnnotator\n - as learned by TrainClassifier");
        private String showDataHelp = new String("interactively view the test dataset in a new window when you run the experiment");
        private String showTestDetailsHelp = new String("visualize test examples along with evaluation\n -Default: true");
        private String showClassifierHelp = new String("interactively view the classifier in a new window when you run the experiment");

        public void showClassifier() {
            this.showClassifier = true;
        }

        public void showData() {
            this.showData = true;
        }

        public void showTestDetails(String bool) {
            this.showTestDetails = new Boolean(bool);
        }

        public void usage() {
            System.out.println("classifier testing parameters:");
            System.out.println(" -loadFrom FILE           " + this.loadFromHelp);
            System.out.println(" [-showData]              " + this.showDataHelp);
            System.out.println(" [-showTestDetails BOOL]  " + this.showTestDetailsHelp);
            System.out.println(" [-showClassifier]        " + this.showClassifierHelp);
            System.out.println();
        }

        public boolean getShowClassifier() {
            return this.showClassifier;
        }

        public void setShowClassifier(boolean flag) {
            this.showClassifier = flag;
        }

        public boolean getShowData() {
            return this.showData;
        }

        public void setShowData(boolean flag) {
            this.showData = flag;
        }

        public boolean getShowTestDetails() {
            return this.showTestDetails;
        }

        public void setShowTestDetails(boolean flag) {
            this.showTestDetails = flag;
        }

        public String getLoadFromHelp() {
            return this.loadFromHelp;
        }

        public String getShowDataHelp() {
            return this.showDataHelp;
        }

        public String getShowTestDetailsHelp() {
            return this.showTestDetailsHelp;
        }

        public String getShowClassifierHelp() {
            return this.showClassifierHelp;
        }
    }

    public static class TrainClassifierParams
    extends BasicCommandLineProcessor {
        public boolean showData = false;
        public String learnerName = "NaiveBayes()";
        public ClassifierLearner learner = new Recommended.NaiveBayes();
        public SpanFeatureExtractor fe = new Recommended.DocumentFE();
        private String embeddedAnnotators = "";
        public String output = "_prediction";
        private String learnerHelp = new String("Bean-shell code to create a ClassifierLearner\n                                 - default is \"new Recommended.NaiveBayes()\"");
        private String showDataHelp = new String("interactively view the constructed training dataset");
        private String feHelp = new String("Bean-shell code to create a SpanFeatureExtractor\n                                 - default is \"new Recommended.DocumentFE()\" ");
        private String mixupHelp = new String("run named mixup code before extracting features");
        private String embedHelp = new String("embed the listed annotators in the feature extractor");
        private String outputHelp = new String("the type or property that is produced by the learned\n                                 ClassifierAnnotator - default is \"_prediction\"");

        public void showData() {
            this.showData = true;
        }

        public void learner(String s) {
            this.learnerName = s;
            this.learner = (ClassifierLearner)CommandLineUtil.newObjectFromBSH(s, ClassifierLearner.class);
        }

        public void output(String s) {
            this.output = s;
        }

        public CommandLineProcessor fe(String s) {
            this.fe = (SpanFeatureExtractor)CommandLineUtil.newObjectFromBSH(s, SpanFeatureExtractor.class);
            if (this.fe instanceof CommandLineProcessor.Configurable) {
                return ((CommandLineProcessor.Configurable)((Object)this.fe)).getCLP();
            }
            return null;
        }

        public void mixup(String s) {
            CommandLineUtil.safeSetRequiredAnnotation(this.fe, s);
        }

        public void embed(String s) {
            this.embeddedAnnotators = s;
            CommandLineUtil.safeSetAnnotatorLoader(this.fe, s);
        }

        public void other(String s) {
            this.option(s);
        }

        public void option(String s) {
            TrainClassifierParams o = this;
            RefUtils.modify(o, s);
        }

        public void LearnerOp(String s) {
            ClassifierLearner o = this.learner;
            RefUtils.modify(o, s);
        }

        public void learnerOp(String s) {
            this.LearnerOp(s);
        }

        public void feOp(String s) {
            if (this.fe != null) {
                SpanFeatureExtractor o = this.fe;
                RefUtils.modify(o, s);
            } else {
                System.out.println("You must define a feature extractor before setting it's options");
            }
        }

        public void usage() {
            System.out.println("classification training parameters:");
            System.out.println(" [-learner BSH]                  " + this.learnerHelp);
            System.out.println(" [-showData]                     " + this.showDataHelp);
            System.out.println(" [-fe FE]                        " + this.feHelp);
            System.out.println("                                 - if FE implements CommandLineProcessor.Configurable then");
            System.out.println("                                   immediately following command-line arguments are passed to it");
            System.out.println(" [-mixup STRING]                 " + this.mixupHelp);
            System.out.println(" [-embed STRING]                 " + this.embedHelp);
            System.out.println(" [-output STRING]                " + this.outputHelp);
            System.out.println(" [-LearnerOp STRING=VALUE]       Extra options that can be defined with the learner");
            System.out.println("                                  - defaults are set");
            System.out.println("                                  - ex: displayDatasetBeforeLearning=true");
            System.out.println(" [-feOp STRING=VALUE]            Extra options that can be defined with the feature extractor");
            System.out.println("                                  - defaults are set");
            System.out.println("                                  - ex: featureWindowSize=4");
            System.out.println();
        }

        public boolean getShowData() {
            return this.showData;
        }

        public void setShowData(boolean flag) {
            this.showData = flag;
        }

        public ClassifierLearner getLearner() {
            return this.learner;
        }

        public void setLearner(ClassifierLearner learner) {
            this.learnerName = learner.getClass().toString();
            if (learner instanceof BatchVersion) {
                this.learnerName = ((BatchVersion)learner).getInnerLearner().toString() + "()";
            }
            System.out.println(this.learnerName);
            this.learner = learner;
        }

        public String getOutput() {
            return this.output;
        }

        public void setOutput(String s) {
            this.output(s);
        }

        public SpanFeatureExtractor getFeatureExtractor() {
            return this.fe;
        }

        public void setFeatureExtractor(SpanFeatureExtractor fe) {
            this.fe = fe;
        }

        public String getMixup() {
            return CommandLineUtil.safeGetRequiredAnnotation(this.fe);
        }

        public void setMixup(String s) {
            CommandLineUtil.safeSetRequiredAnnotation(this.fe, s);
        }

        public String getEmbeddedAnnotators() {
            return this.embeddedAnnotators;
        }

        public void setEmbeddedAnnotators(String s) {
            this.embeddedAnnotators = s;
            CommandLineUtil.safeSetAnnotatorLoader(this.fe, s);
        }

        public String getLearnerHelp() {
            return this.learnerHelp;
        }

        public String getShowDataHelp() {
            return this.showDataHelp;
        }

        public String getFeatureExtractorHelp() {
            return this.feHelp;
        }

        public String getMixupHelp() {
            return this.mixupHelp;
        }

        public String getEmbeddedAnnotatorsHelp() {
            return this.embedHelp;
        }

        public String getOutputHelp() {
            return this.outputHelp;
        }
    }

    public static class ClassificationSignalParams
    extends BasicCommandLineProcessor {
        private BaseParams base = new BaseParams();
        protected String spanPropString = null;
        public String spanType = null;
        public String spanProp = null;
        public String candidateType = null;
        private String spanTypeHelp = new String("create binary dataset, where candidates that\n                                 are marked with spanType TYPE are positive");
        private String spanPropHelp = new String("create multi-class dataset, where candidates\n                                 are given a class determine by the spanProp PROP");
        private String candidateTypeHelp = new String("classify all spans of the given TYPE.\n                                 - default is to classify all document spans");

        public ClassificationSignalParams() {
        }

        public ClassificationSignalParams(BaseParams base) {
            this.base = base;
            if (this.spanPropString != null) {
                this.spanProp = CommandLineUtil.createSpanProp(this.spanPropString, this.base.labels);
            }
        }

        public void spanType(String s) {
            this.spanType = s;
        }

        public void spanProp(String s) {
            if (s.indexOf(44) == -1) {
                this.spanProp = s;
            } else {
                this.spanPropString = s;
                if (this.base.labels != null) {
                    this.spanProp = CommandLineUtil.createSpanProp(this.spanPropString, this.base.labels);
                }
            }
        }

        public void candidateType(String s) {
            this.candidateType = s;
        }

        public String getOutputType(String output) {
            return this.spanType == null ? null : output;
        }

        public String getOutputProp(String output) {
            return this.spanProp == null ? null : output;
        }

        public void usage() {
            System.out.println("classification 'signal' parameters:");
            System.out.println(" -spanType TYPE                  " + this.spanTypeHelp);
            System.out.println(" -spanProp PROP                  " + this.spanPropHelp);
            System.out.println("                                 - exactly one of spanType, spanProp should be specified");
            System.out.println(" [-candidateType TYPE]           " + this.candidateTypeHelp);
            System.out.println();
        }

        public String getSpanType() {
            return this.safeGet(this.spanType, "n/a");
        }

        public void setSpanType(String t) {
            this.spanType = this.safePut(t, "n/a");
        }

        public String getSpanProp() {
            return this.safeGet(this.spanProp, "n/a");
        }

        public void setSpanProp(String p) {
            this.spanProp = this.safePut(p, "n/a");
        }

        public Object[] getAllowedSpanTypeValues() {
            return this.base.labels == null ? new String[]{} : this.base.labels.getTypes().toArray();
        }

        public Object[] getAllowedSpanPropValues() {
            return this.base.labels == null ? new String[]{} : this.base.labels.getSpanProperties().toArray();
        }

        protected String safeGet(String s, String def) {
            return s == null ? def : s;
        }

        protected String safePut(String s, String def) {
            return def.equals(s) ? null : s;
        }

        public String getCandidateType() {
            return this.safeGet(this.candidateType, "top");
        }

        public void setCandidateType(String s) {
            this.candidateType = this.safePut(s, "top");
        }

        public Object[] getAllowedCandidateTypeValues() {
            return this.getAllowedSpanTypeValues();
        }

        public String getSpanTypeHelp() {
            return this.spanTypeHelp;
        }

        public String getSpanPropHelp() {
            return this.spanPropHelp;
        }

        public String getCandidateTypeHelp() {
            return this.candidateTypeHelp;
        }
    }

    public static class EditParams
    extends BasicCommandLineProcessor {
        public File editFile = null;
        private String editFileName = null;
        public String extractedType = null;
        public String trueType = null;
        private String editFilenameHelp = new String("stored result of hand-edited changes to labels in FILE");
        private String extractedTypeHelp = new String("debugging or labeling proposed spans of type TYPE");
        private String trueTypeHelp = new String("hand-corrected labels saved as type TYPE");

        public void extractedType(String s) {
            this.extractedType = s;
        }

        public void trueType(String s) {
            this.trueType = s;
        }

        public void edit(String fileName) {
            this.editFile = new File(fileName);
            this.editFileName = fileName;
        }

        public void usage() {
            System.out.println("edit parameters:");
            System.out.println(" [-edit FILE]             " + this.editFilenameHelp);
            System.out.println(" [-extractedType TYPE]    " + this.extractedTypeHelp);
            System.out.println(" [-trueType TYPE]         " + this.trueTypeHelp);
            System.out.println();
        }

        public String getEditFilename() {
            return this.editFileName == null ? "n/a" : this.editFileName;
        }

        public void setEditFilename(String s) {
            this.edit("n/a".equals(s) ? null : s);
        }

        public String getExtractedType() {
            return this.extractedType == null ? "n/a" : this.extractedType;
        }

        public void setExtractedType(String s) {
            this.extractedType("n/a".equals(s) ? null : s);
        }

        public String getTrueType() {
            return this.trueType == null ? "n/a" : this.trueType;
        }

        public void setTrueType(String s) {
            this.trueType("n/a".equals(s) ? null : s);
        }

        public String getEditFilenameHelp() {
            return this.editFilenameHelp;
        }

        public String getExtractedTypeHelp() {
            return this.extractedTypeHelp;
        }

        public String getTrueTypeHelp() {
            return this.trueTypeHelp;
        }
    }

    public static class SaveParams
    extends BasicCommandLineProcessor {
        public File saveAs = null;
        private String saveAsName = null;
        public String saveHelp = new String("Save final result of this operation in FILE");

        public void saveAs(String fileName) {
            this.saveAs = new File(fileName);
            this.saveAsName = fileName;
        }

        public void usage() {
            System.out.println("save parameters:");
            System.out.println(" [-saveAs FILE]                  " + this.saveHelp);
            System.out.println();
        }

        public String getSaveAs() {
            return this.saveAsName == null ? "n/a" : this.saveAsName;
        }

        public void setSaveAs(String s) {
            this.saveAs("n/a".equals(s) ? null : s);
        }

        public String getSaveAsHelp() {
            return this.saveHelp;
        }
    }

    public static class GUIParams
    extends BasicCommandLineProcessor {
        public boolean useGUI;

        public void gui() {
            this.useGUI = true;
        }

        public void usage() {
            System.out.println("presentation parameters:");
            System.out.println(" -gui                            use graphic interface to set parameters");
            System.out.println();
        }
    }

    public static class BaseParams
    extends BasicCommandLineProcessor {
        public MonotonicTextLabels labels = null;
        public String repositoryKey = "";
        public boolean showLabels = false;
        public boolean showResult = false;
        public boolean classic = false;
        public String labelsFilenameHelp = new String("The Directory of labeled or unlabeled documents you\n                                 would like to load OR the repository key");

        public void labels(String repositoryKey) {
            this.repositoryKey = repositoryKey;
            this.labels = (MonotonicTextLabels)FancyLoader.loadTextLabels(repositoryKey);
        }

        public void showLabels() {
            this.showLabels = true;
        }

        public void showResult() {
            this.showResult = true;
        }

        public void classic() {
            this.classic = true;
        }

        public void usage() {
            System.out.println("basic parameters:");
            System.out.println(" -labels REPOSITORY_KEY          " + this.labelsFilenameHelp);
            System.out.println(" [-showLabels]                   interactively view textBase loaded by -labels");
            System.out.println(" [-showResult]                   interactively view final result of this operation");
            System.out.println();
        }

        public String getLabelsFilename() {
            return this.repositoryKey;
        }

        public void setLabelsFilename(String name) {
            if (name.endsWith(".labels")) {
                this.labels(name.substring(0, name.length() - ".labels".length()));
            } else {
                this.labels(name);
            }
        }

        public String getRepositoryKey() {
            return this.repositoryKey;
        }

        public void setRepositoryKey(String key) {
            this.labels(key);
        }

        public Object[] getAllowedRepositoryKeyValues() {
            return FancyLoader.getPossibleTextLabelKeys();
        }

        public String getLabelsFilenameHelp() {
            return this.labelsFilenameHelp;
        }
    }
}

