/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

import edu.cmu.minorthird.util.CommandLineProcessor;
import edu.cmu.minorthird.util.Saveable;
import edu.cmu.minorthird.util.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicCommandLineProcessor
implements CommandLineProcessor,
Saveable {
    private static Logger log = Logger.getLogger(BasicCommandLineProcessor.class);
    private String[] processedArgs = null;
    private Properties argValues = new Properties();
    private static final String CONFIG_FORMAT_NAME = "Configuration file";
    private static final String CONFIG_FORMAT_EXT = ".config";

    @Override
    public final void processArguments(String[] args) {
        System.out.println("*** Minorthird: " + Version.getVersion() + " ***");
        this.processedArgs = args;
    }

    @Override
    public boolean shouldTerminate() {
        return false;
    }

    @Override
    public final int consumeArguments(String[] args, int startPos) {
        try {
            int pos = startPos;
            while (pos < args.length) {
                String arg = args[pos];
                if (arg.startsWith("--")) {
                    arg = arg.substring(2);
                } else if (arg.startsWith("-")) {
                    arg = arg.substring(1);
                } else {
                    return pos - startPos;
                }
                try {
                    log.info(this.getClass() + " looking for method '" + arg + "'");
                    Method m = this.getClass().getMethod(arg, new Class[0]);
                    log.info(this.getClass() + " consuming '-" + arg + "'");
                    System.out.println("option: " + arg + "=");
                    Object result = m.invoke((Object)this, new Object[0]);
                    ++pos;
                    if (!(result instanceof CommandLineProcessor) || result == null) continue;
                    pos += ((CommandLineProcessor)result).consumeArguments(args, pos);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        Method ms = this.getClass().getMethod(arg, String.class);
                        if (pos + 1 < args.length) {
                            log.info(this.getClass() + " consuming '-" + arg + "' '" + args[pos + 1] + "'");
                            System.out.println("option: " + arg + "=" + args[pos + 1]);
                            Object result = ms.invoke((Object)this, args[pos + 1]);
                            pos += 2;
                            if (!(result instanceof CommandLineProcessor)) continue;
                            pos += ((CommandLineProcessor)result).consumeArguments(args, pos);
                            continue;
                        }
                        throw new IllegalArgumentException("no argument found to option '-" + arg + "'");
                    }
                    catch (NoSuchMethodException ex2) {
                        return pos - startPos;
                    }
                }
            }
            return pos - startPos;
        }
        catch (IllegalAccessException iax) {
            iax.printStackTrace();
            throw new IllegalArgumentException("error: " + iax);
        }
        catch (InvocationTargetException itx) {
            itx.printStackTrace();
            throw new IllegalArgumentException("error: " + itx);
        }
    }

    public void config(String fileName) {
        BasicCommandLineProcessor.config(fileName, this);
    }

    public static void config(String fileName, CommandLineProcessor clp) {
        try {
            String[] fileOptions = BasicCommandLineProcessor.loadOptionsInPropertiesFormat(new File(fileName));
            clp.processArguments(fileOptions);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("error opening " + fileName + ": " + ex);
        }
    }

    @Override
    public void usage(String errorMessage) {
        System.out.println(errorMessage);
        this.usage();
    }

    @Override
    public void usage() {
        Method[] genericMethods = Object.class.getMethods();
        HashSet<String> stopList = new HashSet<String>();
        stopList.add("usage");
        stopList.add("help");
        for (int i = 0; i < genericMethods.length; ++i) {
            Class<?>[] params = genericMethods[i].getParameterTypes();
            if (params.length != 0 && (params.length != 1 || !params[0].equals(String.class))) continue;
            stopList.add(genericMethods[i].getName());
        }
        log.info("usage for " + this.getClass());
        Method[] methods = this.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params = methods[i].getParameterTypes();
            if (stopList.contains(methods[i].getName()) || methods[i].getName().startsWith("get") || methods[i].getName().startsWith("set")) continue;
            if (params.length == 0) {
                System.out.print(" [-" + methods[i].getName() + "]");
                continue;
            }
            if (params.length != 1 || !params[0].equals(String.class)) continue;
            System.out.print(" [-" + methods[i].getName() + " foo]");
        }
        System.out.println();
    }

    public void help() {
        this.usage();
    }

    protected List<String> propertyList() {
        int delta;
        ArrayList<String> result = new ArrayList<String>();
        this.argValues.clear();
        for (int k = 0; k < this.processedArgs.length; k += delta) {
            String opt = this.processedArgs[k];
            String val = "";
            delta = 1;
            if (k + 1 < this.processedArgs.length && !this.processedArgs[k + 1].startsWith("-")) {
                val = this.processedArgs[k + 1];
                delta = 2;
            }
            String prop = opt.substring(1);
            result.add(prop);
            this.argValues.setProperty(prop, val);
        }
        return result;
    }

    protected String propertyValue(String property) {
        return this.argValues.getProperty(property);
    }

    @Override
    public String[] getFormatNames() {
        return new String[]{CONFIG_FORMAT_NAME};
    }

    @Override
    public String getExtensionFor(String format) {
        return CONFIG_FORMAT_EXT;
    }

    @Override
    public void saveAs(File file, String format) throws IOException {
        if (!format.equals(CONFIG_FORMAT_NAME)) {
            throw new IllegalArgumentException("illegal format " + format);
        }
        PrintStream s = new PrintStream(new FileOutputStream(file));
        for (String prop : this.propertyList()) {
            s.println(prop + "=" + this.propertyValue(prop));
        }
        s.close();
    }

    @Override
    public Object restore(File file) throws IOException {
        throw new UnsupportedOperationException("Can't restore a command line processor");
    }

    protected CommandLineProcessor tryToGetCLP(Object o) {
        if (o instanceof CommandLineProcessor.Configurable) {
            return ((CommandLineProcessor.Configurable)o).getCLP();
        }
        throw new IllegalArgumentException(o + " can't be configured from the command line");
    }

    private static String[] loadOptionsInPropertiesFormat(File file) throws IOException {
        String line;
        ArrayList<String> accum = new ArrayList<String>();
        LineNumberReader in = new LineNumberReader(new FileReader(file));
        while ((line = in.readLine()) != null) {
            if (line.trim().length() <= 0 || line.charAt(0) == '#') continue;
            int eqPos = line.indexOf(61);
            if (eqPos < 0) {
                BasicCommandLineProcessor.inputError(in, line, file, "no equal-sign (=) in line");
                continue;
            }
            String option = line.substring(0, eqPos).trim();
            String value = line.substring(eqPos + 1).trim();
            accum.add("-" + option);
            if (value.length() <= 0) continue;
            accum.add(value);
        }
        return accum.toArray(new String[accum.size()]);
    }

    private static void inputError(LineNumberReader in, String line, File file, String msg) {
        log.warn(file + ", line " + in.getLineNumber() + ": " + msg);
        log.warn(" - incorrect line is '" + line + "'");
    }
}

