/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util;

import edu.cmu.minorthird.util.StringUtil;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefUtils {
    private static Logger log = Logger.getLogger(RefUtils.class);
    private static int LHS = 0;
    private static int RHS = 1;

    private static String toGetter(String s) {
        return "get" + s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String toSetter(String s) {
        return "set" + s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static Object toObject(String s, Class<?> c) {
        if ((c == Boolean.class || c == Boolean.TYPE) && s.equalsIgnoreCase("true")) {
            return new Boolean(true);
        }
        if ((c == Boolean.class || c == Boolean.TYPE) && s.equalsIgnoreCase("false")) {
            return new Boolean(false);
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return new Integer(StringUtil.atoi(s));
        }
        if (c == Double.class || c == Double.TYPE) {
            return new Double(StringUtil.atof(s));
        }
        try {
            return Class.forName(s).newInstance();
        }
        catch (Exception ex1) {
            try {
                return Class.forName("edu.cmu.minorthird." + s).newInstance();
            }
            catch (Exception ex2) {
                try {
                    int i = s.lastIndexOf(46);
                    int len = s.length();
                    String s2 = s.substring(0, i) + "$" + s.substring(i + 1, len);
                    return Class.forName("edu.cmu.minorthird." + s2).newInstance();
                }
                catch (Exception ex3) {
                    try {
                        int i = s.lastIndexOf(46);
                        int len = s.length();
                        String s2 = s.substring(0, i) + "$" + s.substring(i + 1, len);
                        return Class.forName(s2).newInstance();
                    }
                    catch (Exception ex4) {
                        throw new IllegalArgumentException("can't create instance of '" + s + "' or 'edu.cmu.minorthird." + s + "'");
                    }
                }
            }
        }
    }

    public static Object modify(Object obj, String modifications) {
        String[] mods = modifications.split("[,;]\\s*");
        for (int i = 0; i < mods.length; ++i) {
            String[] sides = mods[i].split("=");
            if (sides.length != 2) {
                log.warn("Illegal modification (should be of the form x=y): " + mods[i]);
                continue;
            }
            String[] path = sides[LHS].split("\\.");
            Object objToChange = obj;
            try {
                for (int j = 0; j < path.length - 1; ++j) {
                    Method m = objToChange.getClass().getMethod(RefUtils.toGetter(path[j]), new Class[0]);
                    objToChange = m.invoke(objToChange, new Object[0]);
                }
                Method m = null;
                Method[] ms = objToChange.getClass().getMethods();
                String setterName = RefUtils.toSetter(path[path.length - 1]);
                for (int k = 0; k < ms.length; ++k) {
                    if (!setterName.equals(ms[k].getName())) continue;
                    m = ms[k];
                    break;
                }
                if (m == null) {
                    log.warn("No setter defined for '" + path[path.length - 1] + "'");
                    continue;
                }
                Class<?>[] expectedClasses = m.getParameterTypes();
                Object rhs = RefUtils.toObject(sides[RHS], expectedClasses[0]);
                m.invoke(objToChange, rhs);
                continue;
            }
            catch (Exception ex) {
                log.warn("Can't execute modification '" + mods[i] + "': error was " + ex);
            }
        }
        return obj;
    }
}

