/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.minorthird.util.gui;

import edu.cmu.minorthird.util.gui.ComponentViewer;
import edu.cmu.minorthird.util.gui.ViewerFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSelector
extends ComponentViewer {
    static final long serialVersionUID = 20080517L;
    private static boolean DEBUG = false;
    private static Logger log = Logger.getLogger(TypeSelector.class);
    private final Class<?> rootClass;
    private List<Class<?>> validSubclasses = new ArrayList();
    private List<String> inLineClasses = new ArrayList<String>();
    private boolean inLine = false;
    private List<String> advancedParams = new ArrayList<String>();
    private final Map<String, Object> instanceMap = new HashMap<String, Object>();
    private JComboBox classBox;
    private String name = null;

    public TypeSelector(Class<?>[] validSubclasses, Class<?> rootClass) {
        this(validSubclasses, null, rootClass);
    }

    public TypeSelector(Class<?>[] validSubclasses, String configFilename, Class<?> rootClass) {
        this(validSubclasses, null, null, configFilename, rootClass);
    }

    public TypeSelector(Class<?>[] validSubclasses, String[] inLineClasses, String[] advancedParams, String configFilename, Class<?> rootClass) {
        this.validSubclasses.addAll(Arrays.asList(validSubclasses));
        if (inLineClasses != null) {
            this.inLineClasses.addAll(Arrays.asList(inLineClasses));
        } else {
            inLineClasses = null;
        }
        if (advancedParams != null) {
            this.advancedParams.addAll(Arrays.asList(advancedParams));
        } else {
            advancedParams = null;
        }
        if (configFilename != null) {
            this.configureWith(configFilename);
        }
        this.rootClass = rootClass;
        this.init(rootClass);
    }

    private TypeSelector(List<Class<?>> validClasses, List<String> inLineClasses, List<String> advancedParams, Class<?> rootClass, boolean inLine) {
        this.validSubclasses = validClasses;
        this.inLineClasses = inLineClasses;
        this.advancedParams = advancedParams;
        this.rootClass = rootClass;
        this.inLine = inLine;
        this.init(rootClass);
    }

    private void configureWith(String filename) {
        try {
            LineNumberReader r = null;
            File file = new File(filename);
            if (file.exists()) {
                r = new LineNumberReader(new BufferedReader(new FileReader(file)));
            } else {
                InputStream s = ClassLoader.getSystemResourceAsStream(filename);
                if (s == null) {
                    log.error("No file named '" + filename + "' found on classpath");
                } else {
                    r = new LineNumberReader(new BufferedReader(new InputStreamReader(s)));
                }
            }
            if (r != null) {
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    try {
                        this.validSubclasses.add(Class.forName(line));
                    }
                    catch (ClassNotFoundException ex) {
                        log.warn(filename + ":" + r.getLineNumber() + ": No class named '" + line + "' found.");
                    }
                }
            }
        }
        catch (IOException ex) {
            log.error("Exception reading " + filename + ": " + ex);
            return;
        }
    }

    private void init(Class<?> rootClass) {
        for (int i = 0; i < this.validSubclasses.size(); ++i) {
            if (!rootClass.isAssignableFrom(this.validSubclasses.get(i))) continue;
            try {
                Object instance = this.validSubclasses.get(i).newInstance();
                this.instanceMap.put(this.shortenedClassName(this.validSubclasses.get(i)), instance);
                continue;
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                log.warn("can't create instance of " + this.validSubclasses.get(i) + ": " + ex);
                continue;
            }
            catch (IllegalAccessException ex) {
                log.warn("can't create instance of " + this.validSubclasses.get(i) + ": " + ex);
            }
        }
    }

    public String shortenedClassName(Class<?> item) {
        String fullName = item.getName();
        String[] splitName = fullName.split("\\W");
        String className = splitName[splitName.length - 1];
        return className;
    }

    @Override
    public JComponent componentFor(Object o) {
        if (this.inLine) {
            return this.InLineComponent(o);
        }
        return this.BoxComponent(o);
    }

    public JComponent BoxComponent(final Object o) {
        if (!this.rootClass.isAssignableFrom(o.getClass())) {
            throw new IllegalArgumentException("not instance of " + this.rootClass + ": " + o);
        }
        JPanel panel = new JPanel();
        if (this.instanceMap.get(this.shortenedClassName(o.getClass())) != null) {
            this.instanceMap.put(this.shortenedClassName(o.getClass()), o);
        }
        this.classBox = new JComboBox();
        for (String key : this.instanceMap.keySet()) {
            log.debug("adding to classBox " + key);
            this.classBox.addItem(key);
        }
        String currentName = this.shortenedClassName(o.getClass());
        this.classBox.setSelectedItem(currentName);
        this.classBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                TypeSelector.this.sendSignal(3, TypeSelector.this.instanceMap.get(TypeSelector.this.classBox.getSelectedItem()));
            }
        });
        panel.add(this.classBox);
        if (DEBUG) {
            panel.add(new JButton(new AbstractAction("Print"){
                static final long serialVersionUID = 20080517L;

                public void actionPerformed(ActionEvent e) {
                    System.out.println("current selection: " + TypeSelector.this.instanceMap.get(TypeSelector.this.classBox.getSelectedItem()));
                }
            }));
        }
        panel.add(new JButton(new AbstractAction("Edit"){
            static final long serialVersionUID = 20080517L;

            public void actionPerformed(ActionEvent e) {
                log.debug("pressed edit");
                PropertyEditor editor = new PropertyEditor(true, false);
                editor.setContent(TypeSelector.this.instanceMap.get(TypeSelector.this.classBox.getSelectedItem()));
                String title = TypeSelector.this.name == null ? "Property Editor" : "Property Editor for " + TypeSelector.this.name;
                JOptionPane optionPane = new JOptionPane(new Object[]{title, editor});
                JDialog dialog = optionPane.createDialog(TypeSelector.this, title);
                dialog.setVisible(true);
            }
        }));
        try {
            BeanInfo info = Introspector.getBeanInfo(o.getClass());
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            for (int i = 0; i < props.length; ++i) {
                log.debug("inspecting property: " + props[i].getShortDescription());
                final String pname = props[i].getDisplayName();
                Method reader = props[i].getReadMethod();
                String[] classes = o.getClass().getName().split("\\.");
                String name = classes[classes.length - 1];
                if (reader == null || !pname.equalsIgnoreCase(name + "Help")) continue;
                final Object value = reader.invoke(o, new Object[0]);
                panel.add(new JButton(new AbstractAction("?"){
                    static final long serialVersionUID = 20080517L;

                    public void actionPerformed(ActionEvent e) {
                        log.debug("pressed help");
                        HelpViewer editor = new HelpViewer();
                        editor.setContent(value);
                        String title = pname == null ? "Help" : "Help for " + o.getClass().getName();
                        JOptionPane optionPane = new JOptionPane(new Object[]{editor});
                        JDialog dialog = optionPane.createDialog(TypeSelector.this, title);
                        dialog.setVisible(true);
                    }
                }));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Help does not work");
        }
        return panel;
    }

    public JComponent InLineComponent(Object o) {
        if (!this.rootClass.isAssignableFrom(o.getClass())) {
            throw new IllegalArgumentException("not instance of " + this.rootClass + ": " + o);
        }
        JPanel panel = new JPanel();
        if (this.instanceMap.get(this.shortenedClassName(o.getClass())) != null) {
            this.instanceMap.put(this.shortenedClassName(o.getClass()), o);
        }
        this.classBox = new JComboBox();
        for (String key : this.instanceMap.keySet()) {
            log.debug("adding to classBox " + key);
            this.classBox.addItem(key);
        }
        String currentName = this.shortenedClassName(o.getClass());
        this.classBox.setSelectedItem(currentName);
        this.classBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                TypeSelector.this.sendSignal(3, TypeSelector.this.instanceMap.get(TypeSelector.this.classBox.getSelectedItem()));
            }
        });
        if (this.instanceMap.size() > 1) {
            panel.add(this.classBox);
        }
        if (DEBUG) {
            panel.add(new JButton(new AbstractAction("Print"){
                static final long serialVersionUID = 20080517L;

                public void actionPerformed(ActionEvent e) {
                    System.out.println("current selection: " + TypeSelector.this.instanceMap.get(TypeSelector.this.classBox.getSelectedItem()));
                }
            }));
        }
        PropertyEditor editor = new PropertyEditor();
        editor.setContent(this.instanceMap.get(this.classBox.getSelectedItem()));
        panel.add(editor);
        return panel;
    }

    public void createPE(Class<?> type) {
        PropertyEditor editor = new PropertyEditor(true, true);
        editor.setContent(this.instanceMap.get(this.shortenedClassName(type)));
        String title = this.name == null ? "Property Editor" : "Property Editor for " + this.name;
        JOptionPane optionPane = new JOptionPane(new Object[]{title, editor});
        JDialog dialog = optionPane.createDialog(this, title);
        dialog.setVisible(true);
    }

    private boolean isInLine(String c) {
        for (int i = 0; i < this.inLineClasses.size(); ++i) {
            if (!c.equals(this.inLineClasses.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean isAdvanced(String s) {
        if (this.advancedParams == null) {
            return false;
        }
        for (int i = 0; i < this.advancedParams.size(); ++i) {
            if (!s.equals(this.advancedParams.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            TypeSelector t = new TypeSelector(new Class[]{SampleInner.class, SampleOuter.class}, AbstractSample.class);
            SampleOuter s = new SampleOuter();
            s.setName("fred");
            t.setContent(s);
            new ViewerFrame("test", t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SampleInner
    extends AbstractSample {
        private int z = 0;

        public int getZ() {
            return this.z;
        }

        public void setZ(int z) {
            this.z = z;
        }

        public String toString() {
            return "[SampleInner " + this.getName() + ": x,z,inner=" + this.getX() + "," + this.getZ() + "]";
        }
    }

    public static class SampleOuter
    extends AbstractSample {
        private int y = 0;
        private AbstractSample inner = new SampleInner();

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public AbstractSample getInner() {
            return this.inner;
        }

        public void setInner(AbstractSample inner) {
            this.inner = inner;
        }

        public String toString() {
            return "[SampleOuter " + this.getName() + ": flag,x,y,inner=" + this.getFlag() + "," + this.getX() + "," + this.getY() + "," + this.getInner() + "]";
        }
    }

    public static class AbstractSample {
        private int x = 10;
        private double d = 0.33;
        private String name = "fooBar";
        private boolean flag = true;

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
            this.name = s;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public double getDFraction() {
            return this.d;
        }

        public void setDFraction(double f) {
            this.d = f;
        }

        public boolean getFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PropertyEditor
    extends ComponentViewer {
        static final long serialVersionUID = 20080517L;
        boolean warning = false;
        boolean useAdvanced = false;

        public PropertyEditor() {
        }

        public PropertyEditor(boolean warn, boolean useAdv) {
            this.warning = warn;
            this.useAdvanced = useAdv;
        }

        @Override
        public JComponent componentFor(final Object o) {
            JPanel wholePanel = new JPanel();
            wholePanel.setLayout(new GridBagLayout());
            int numTextFields = 0;
            int numTypeSelectors = 0;
            int numAdvancedParams = 0;
            int row = 0;
            try {
                BeanInfo info = Introspector.getBeanInfo(o.getClass());
                PropertyDescriptor[] props = info.getPropertyDescriptors();
                int i = 0;
                while (i < props.length) {
                    Object value;
                    boolean isHelp;
                    Method reader2;
                    this.log.debug("inspecting property: " + props[i].getShortDescription());
                    final String pname = props[i].getDisplayName();
                    Class<?> type = props[i].getPropertyType();
                    Method reader = props[i].getReadMethod();
                    final Method writer = props[i].getWriteMethod();
                    String pname2 = ++i < props.length ? props[i].getDisplayName() : null;
                    Method method = reader2 = i < props.length ? props[i].getReadMethod() : null;
                    if (reader2 != null && pname2 != null && pname2.endsWith("Help") && pname.charAt(0) == pname2.charAt(0) && (!TypeSelector.this.isAdvanced(pname2) && !this.useAdvanced || this.useAdvanced && TypeSelector.this.isAdvanced(pname2))) {
                        ++i;
                        isHelp = true;
                    } else {
                        isHelp = false;
                    }
                    final Selection selection = new Selection();
                    JPanel panel = new JPanel();
                    panel.setBorder(new EmptyBorder(0, 0, 0, 0));
                    if (reader != null && writer != null) {
                        value = reader.invoke(o, new Object[0]);
                        if (!TypeSelector.this.isAdvanced(pname) && !this.useAdvanced || this.useAdvanced && TypeSelector.this.isAdvanced(pname)) {
                            JSpinner spinner;
                            ++row;
                            if (TypeSelector.this.isInLine(pname)) {
                                TypeSelector.this.inLine = true;
                            }
                            this.log.debug("reader: " + reader.getName());
                            if (!TypeSelector.this.isInLine(pname)) {
                                panel.add((Component)new JLabel(pname + ":"), this.gbc(0, row));
                            }
                            if (type.equals(String.class)) {
                                try {
                                    String allowedValueMethodName = "getAllowed" + pname.substring(0, 1).toUpperCase() + pname.substring(1) + "Values";
                                    Method allowedValueMethod = o.getClass().getMethod(allowedValueMethodName, new Class[0]);
                                    Object[] allowedValues = (Object[])allowedValueMethod.invoke(o, new Object[0]);
                                    final JComboBox<Object> theBox = new JComboBox<Object>();
                                    theBox.addItem("-choose a value-");
                                    for (int j = 0; j < allowedValues.length; ++j) {
                                        theBox.addItem(allowedValues[j]);
                                    }
                                    theBox.setSelectedItem(value);
                                    theBox.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ev) {
                                            try {
                                                if (theBox.getSelectedIndex() > 0) {
                                                    writer.invoke(o, theBox.getSelectedItem());
                                                } else {
                                                    writer.invoke(o, new Object[]{null});
                                                }
                                            }
                                            catch (IllegalAccessException ex) {
                                                PropertyEditor.this.log.error(ex.toString());
                                            }
                                            catch (InvocationTargetException ex) {
                                                PropertyEditor.this.log.error(ex.toString());
                                            }
                                        }
                                    });
                                    panel.add(theBox, this.gbc(1, row));
                                }
                                catch (NoSuchMethodException ex) {
                                    final JTextField textField = new JTextField(10);
                                    textField.setText(value == null ? "" : value.toString());
                                    textField.addActionListener(new ActionListener(){

                                        public void actionPerformed(ActionEvent ev) {
                                            try {
                                                PropertyEditor.this.log.debug("change to " + textField.getText());
                                                writer.invoke(o, textField.getText());
                                            }
                                            catch (IllegalAccessException ex) {
                                                PropertyEditor.this.log.error(ex.toString());
                                            }
                                            catch (InvocationTargetException ex) {
                                                PropertyEditor.this.log.error(ex.toString());
                                            }
                                        }
                                    });
                                    if (pname.indexOf("Filename") < 0) {
                                        panel.add((Component)textField, this.gbc(1, row));
                                    } else {
                                        final JFileChooser chooser = new JFileChooser();
                                        chooser.setFileSelectionMode(2);
                                        JButton browseButton = new JButton(new AbstractAction("Browse"){
                                            static final long serialVersionUID = 20080517L;

                                            public void actionPerformed(ActionEvent ev) {
                                                int returnVal = chooser.showOpenDialog(null);
                                                if (returnVal == 0) {
                                                    String filename = chooser.getSelectedFile().getAbsolutePath();
                                                    textField.setText(filename);
                                                    try {
                                                        PropertyEditor.this.log.debug("change to " + textField.getText());
                                                        writer.invoke(o, filename);
                                                    }
                                                    catch (IllegalAccessException ex) {
                                                        PropertyEditor.this.log.error(ex.toString());
                                                    }
                                                    catch (InvocationTargetException ex) {
                                                        PropertyEditor.this.log.error(ex.toString());
                                                    }
                                                }
                                            }
                                        });
                                        JPanel typeOrBrowsePanel = new JPanel();
                                        typeOrBrowsePanel.add(textField);
                                        typeOrBrowsePanel.add(browseButton);
                                        panel.add((Component)typeOrBrowsePanel, this.gbc(1, row));
                                    }
                                    ++numTextFields;
                                }
                            } else if (type.equals(Integer.TYPE)) {
                                spinner = new JSpinner(new SpinnerNumberModel((Integer)value, -1, 100, 1));
                                spinner.addChangeListener(new ChangeListener(){

                                    public void stateChanged(ChangeEvent e) {
                                        try {
                                            PropertyEditor.this.log.debug("change to " + spinner.getValue());
                                            writer.invoke(o, spinner.getValue());
                                        }
                                        catch (IllegalAccessException ex) {
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                            // empty catch block
                                        }
                                    }
                                });
                                panel.add((Component)spinner, this.gbc(1, row));
                            } else if (type.equals(Double.TYPE) && pname.indexOf("Fraction") >= 0) {
                                spinner = new JSpinner(new SpinnerNumberModel((Double)value, 0.0, 100.0, 0.05));
                                spinner.addChangeListener(new ChangeListener(){

                                    public void stateChanged(ChangeEvent e) {
                                        try {
                                            PropertyEditor.this.log.debug("change to " + spinner.getValue());
                                            writer.invoke(o, spinner.getValue());
                                        }
                                        catch (IllegalAccessException ex) {
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                            // empty catch block
                                        }
                                    }
                                });
                                panel.add((Component)spinner, this.gbc(1, row, 10));
                            } else if (type.equals(Double.TYPE)) {
                                final JTextField textField = new JTextField(10);
                                textField.setText(value.toString());
                                textField.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        try {
                                            PropertyEditor.this.log.debug("change to " + textField.getText());
                                            double d = Double.parseDouble(textField.getText().trim());
                                            writer.invoke(o, new Double(d));
                                        }
                                        catch (IllegalAccessException ex) {
                                        }
                                        catch (InvocationTargetException ex) {
                                        }
                                        catch (NumberFormatException ex) {
                                            PropertyEditor.this.log.warn("Illegal number '" + textField.getText() + "'");
                                        }
                                    }
                                });
                                panel.add((Component)textField, this.gbc(1, row));
                                ++numTextFields;
                            } else if (type.equals(Boolean.TYPE)) {
                                final JCheckBox checkbox = new JCheckBox();
                                checkbox.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent ev) {
                                        try {
                                            PropertyEditor.this.log.debug("change to " + checkbox.isSelected());
                                            writer.invoke(o, new Boolean(checkbox.isSelected()));
                                        }
                                        catch (IllegalAccessException ex) {
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                            // empty catch block
                                        }
                                    }
                                });
                                checkbox.setSelected((Boolean)value);
                                panel.add((Component)checkbox, this.gbc(1, row));
                            } else if (value != null && this.isValid(value.getClass())) {
                                if (TypeSelector.this.isInLine(pname)) {
                                    panel.setBorder(new TitledBorder(pname));
                                }
                                this.log.debug("type " + value.getClass() + " is editable");
                                this.log.debug("add selector on type " + type + " of " + TypeSelector.this.validSubclasses);
                                final TypeSelector selector = new TypeSelector(TypeSelector.this.validSubclasses, TypeSelector.this.inLineClasses, TypeSelector.this.advancedParams, type, TypeSelector.this.isInLine(pname));
                                ++numTypeSelectors;
                                selector.setContent(value);
                                selector.name = TypeSelector.this.name == null ? pname : TypeSelector.this.name + "." + pname;
                                Object selected = selector.instanceMap.get(selector.classBox.getSelectedItem());
                                selection.setSelected(selected);
                                selector.classBox.addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e) {
                                        try {
                                            Object selected = selector.instanceMap.get(selector.classBox.getSelectedItem());
                                            selection.setSelected(selected);
                                            writer.invoke(o, selected);
                                        }
                                        catch (IllegalAccessException ex) {
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                            // empty catch block
                                        }
                                    }
                                });
                                panel.add((Component)selector, this.gbc(1, row));
                            } else {
                                this.log.debug("type " + type + " is not editable");
                                panel.add((Component)new JLabel(value == null ? "null " : value.toString()), this.gbc(1, row));
                            }
                            this.log.debug("property " + row + "\n  name: " + TypeSelector.this.name + "\n  type: " + type + "\n  value: " + value);
                            if (value != null) {
                                this.log.debug("class of value is: " + value.getClass());
                            } else {
                                this.log.debug("null value, no class");
                            }
                        } else {
                            ++numAdvancedParams;
                        }
                        wholePanel.add((Component)panel, this.gbc(1, row));
                    }
                    if (!isHelp) continue;
                    value = reader2.invoke(o, new Object[0]);
                    panel.add((Component)new JButton(new AbstractAction("?"){
                        static final long serialVersionUID = 20080517L;

                        public void actionPerformed(ActionEvent e) {
                            PropertyEditor.this.log.debug("pressed help");
                            HelpViewer editor = new HelpViewer();
                            String helpString = value.toString();
                            if (selection.itemSelected != null) {
                                String selectedItem = selection.itemSelected.toString();
                                if (selectedItem.indexOf(64) > 0) {
                                    selectedItem = selectedItem.substring(0, selectedItem.indexOf(64));
                                }
                                String javadocLink = selectedItem;
                                if ((javadocLink = javadocLink.replaceAll("\\.", "\\/")).indexOf(36) > 0) {
                                    javadocLink = javadocLink.replaceAll("\\$", "\\.");
                                }
                                javadocLink = "http://minorthird.sourceforge.net/javadoc/" + javadocLink;
                                helpString = helpString + "<br>Your current selection is:  <a href=\"" + javadocLink + ".html\">" + selectedItem + "</a>";
                            }
                            editor.setContent(helpString);
                            String title = pname == null ? "Help" : "Help for " + pname;
                            JOptionPane optionPane = new JOptionPane(new Object[]{editor});
                            JDialog dialog = optionPane.createDialog(TypeSelector.this, title);
                            dialog.setVisible(true);
                        }
                    }), this.gbc(1, row));
                }
                if (numAdvancedParams > 0 && TypeSelector.this.inLine) {
                    JButton advancedOptions = new JButton("advanced options");
                    advancedOptions.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TypeSelector selector = new TypeSelector(TypeSelector.this.validSubclasses, TypeSelector.this.inLineClasses, TypeSelector.this.advancedParams, o.getClass(), false);
                            selector.setContent(o);
                            selector.classBox.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                }
                            });
                            selector.createPE(o.getClass());
                        }
                    });
                    wholePanel.add((Component)advancedOptions, this.gbc(1, ++row));
                }
                if (row == 0) {
                    wholePanel.add(new JLabel("No properties to edit for class " + o.getClass()));
                }
                if (this.warning && (numTypeSelectors > 0 || numTextFields > 0)) {
                    wholePanel.add((Component)new JLabel("[Reminder: text will not be saved unless you use ENTER]"), this.gbc(0, row + 1, 2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Editor on input " + o + ": " + e.toString());
            }
            JScrollPane scroller = new JScrollPane(wholePanel);
            scroller.setHorizontalScrollBarPolicy(30);
            return scroller;
        }

        private GridBagConstraints gbc(int x, int y) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridx = x;
            gbc.gridy = y;
            gbc.ipadx = 10;
            gbc.anchor = y == 0 ? 13 : 17;
            return gbc;
        }

        private GridBagConstraints gbc(int x, int y, int w) {
            GridBagConstraints gbc = this.gbc(x, y);
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            gbc.gridwidth = w;
            return gbc;
        }

        private boolean isValid(Class<?> c) {
            for (int i = 0; i < TypeSelector.this.validSubclasses.size(); ++i) {
                if (!c.equals(TypeSelector.this.validSubclasses.get(i))) continue;
                return true;
            }
            return false;
        }

        public class Selection {
            public Object itemSelected = null;

            public void setSelected(Object selected) {
                this.itemSelected = selected;
            }
        }
    }

    public class HelpViewer
    extends ComponentViewer
    implements HyperlinkListener {
        static final long serialVersionUID = 20080517L;

        public JComponent componentFor(Object o) {
            try {
                JPanel helpPanel = new JPanel();
                JEditorPane ep = new JEditorPane();
                ep.setEditorKit(new HTMLEditorKit());
                ep.setText((String)o);
                ep.setEditable(false);
                ep.addHyperlinkListener(this);
                helpPanel.add(ep);
                return helpPanel;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Must give the help viewer a String");
            }
        }

        public void hyperlinkUpdate(HyperlinkEvent he) {
            if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    String osName = System.getProperty("os.name");
                    String url = he.getURL().toString();
                    if (osName.startsWith("Mac OS")) {
                        Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                        Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                        openURL.invoke(null, url);
                    } else if (osName.startsWith("Windows")) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                    } else {
                        String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                        String browser = null;
                        for (int count = 0; count < browsers.length && browser == null; ++count) {
                            if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                            browser = browsers[count];
                        }
                        if (browser == null) {
                            throw new Exception("Could not find web browser");
                        }
                        Runtime.getRuntime().exec(new String[]{browser, url});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Cannot open web page: " + e);
                }
            }
        }
    }
}

