/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.bin;

import cern.colt.buffer.DoubleBuffer;
import cern.colt.buffer.DoubleBufferConsumer;
import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import hep.aida.bin.AbstractBin;

public abstract class AbstractBin1D
extends AbstractBin
implements DoubleBufferConsumer {
    protected AbstractBin1D() {
    }

    public abstract void add(double var1);

    public final synchronized void addAllOf(DoubleArrayList doubleArrayList) {
        this.addAllOfFromTo(doubleArrayList, 0, doubleArrayList.size() - 1);
    }

    public synchronized void addAllOfFromTo(DoubleArrayList doubleArrayList, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.add(doubleArrayList.getQuick(n3));
            ++n3;
        }
    }

    public synchronized DoubleBuffer buffered(int n) {
        return new DoubleBuffer(this, n);
    }

    public String compareWith(AbstractBin1D abstractBin1D) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nDifferences [percent]");
        stringBuffer.append("\nSize: " + this.relError(this.size(), abstractBin1D.size()) + " %");
        stringBuffer.append("\nSum: " + this.relError(this.sum(), abstractBin1D.sum()) + " %");
        stringBuffer.append("\nSumOfSquares: " + this.relError(this.sumOfSquares(), abstractBin1D.sumOfSquares()) + " %");
        stringBuffer.append("\nMin: " + this.relError(this.min(), abstractBin1D.min()) + " %");
        stringBuffer.append("\nMax: " + this.relError(this.max(), abstractBin1D.max()) + " %");
        stringBuffer.append("\nMean: " + this.relError(this.mean(), abstractBin1D.mean()) + " %");
        stringBuffer.append("\nRMS: " + this.relError(this.rms(), abstractBin1D.rms()) + " %");
        stringBuffer.append("\nVariance: " + this.relError(this.variance(), abstractBin1D.variance()) + " %");
        stringBuffer.append("\nStandard deviation: " + this.relError(this.standardDeviation(), abstractBin1D.standardDeviation()) + " %");
        stringBuffer.append("\nStandard error: " + this.relError(this.standardError(), abstractBin1D.standardError()) + " %");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractBin1D)) {
            return false;
        }
        AbstractBin1D abstractBin1D = (AbstractBin1D)object;
        return this.size() == abstractBin1D.size() && this.min() == abstractBin1D.min() && this.max() == abstractBin1D.max() && this.sum() == abstractBin1D.sum() && this.sumOfSquares() == abstractBin1D.sumOfSquares();
    }

    public abstract double max();

    public synchronized double mean() {
        return this.sum() / (double)this.size();
    }

    public abstract double min();

    protected double relError(double d, double d2) {
        return 100.0 * (1.0 - d / d2);
    }

    public synchronized double rms() {
        return Descriptive.rms(this.size(), this.sumOfSquares());
    }

    public synchronized double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public synchronized double standardError() {
        return Descriptive.standardError(this.size(), this.variance());
    }

    public abstract double sum();

    public abstract double sumOfSquares();

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("\n-------------");
        stringBuffer.append("\nSize: " + this.size());
        stringBuffer.append("\nSum: " + this.sum());
        stringBuffer.append("\nSumOfSquares: " + this.sumOfSquares());
        stringBuffer.append("\nMin: " + this.min());
        stringBuffer.append("\nMax: " + this.max());
        stringBuffer.append("\nMean: " + this.mean());
        stringBuffer.append("\nRMS: " + this.rms());
        stringBuffer.append("\nVariance: " + this.variance());
        stringBuffer.append("\nStandard deviation: " + this.standardDeviation());
        stringBuffer.append("\nStandard error: " + this.standardError());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public synchronized void trimToSize() {
    }

    public synchronized double variance() {
        return Descriptive.sampleVariance(this.size(), this.sum(), this.sumOfSquares());
    }
}

