/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import java.io.Serializable;

class EdgeGenerator
implements Serializable {
    int offset = 1;
    int numOrigY;
    int histsize;

    EdgeGenerator(int histsize, int numOrigY) {
        for (int i = 0; i < histsize - 1; ++i) {
            this.offset *= numOrigY;
        }
        this.numOrigY = numOrigY;
        this.histsize = histsize;
    }

    int first(int destY) {
        return destY / this.numOrigY;
    }

    int next(int destY, int currentSrcY) {
        return currentSrcY + this.offset;
    }

    int firstY(int pos) {
        return 0;
    }

    int nextY(int currentY, int pos) {
        if (pos >= this.histsize - 1 || currentY < this.numOrigY - 1) {
            return currentY + 1;
        }
        if ((double)currentY >= Math.pow(this.numOrigY, pos + 1)) {
            return this.numOrigY * this.offset;
        }
        return currentY + 1;
    }
}

