/*
 * Decompiled with CFR 0.152.
 */
package iitb.CRF;

import iitb.CRF.DataIter;
import iitb.CRF.DataSequence;
import iitb.CRF.EdgeGenerator;
import iitb.CRF.Feature;
import iitb.CRF.FeatureGenerator;
import iitb.Model.FeatureImpl;
import iitb.Utils.Counters;
import java.io.Serializable;

class HistoryManager
implements Serializable {
    int histsize;
    int numOrigY;
    int numY;

    HistoryManager(int histsize, int num) {
        this.histsize = histsize;
        this.numOrigY = num;
        this.numY = num;
        for (int i = 0; i < histsize - 1; ++i) {
            this.numY *= num;
        }
    }

    FeatureGenerator getFeatureGen(FeatureGenerator fgen) {
        if (this.histsize == 1) {
            return fgen;
        }
        return new FeatureGeneratorWithHistory(fgen);
    }

    DataIter mapTrainData(DataIter trainData) {
        if (this.histsize == 1) {
            return trainData;
        }
        return new DataIterHistory(trainData);
    }

    void set_y(DataSequence data, int i, int label) {
        if (this.histsize > 1) {
            data.set_y(i, label % this.numOrigY);
        }
    }

    int getOrigY(int label) {
        return label % this.numOrigY;
    }

    EdgeGenerator getEdgeGenerator() {
        return new EdgeGenerator(this.histsize, this.numOrigY);
    }

    class DataIterHistory
    implements DataIter {
        DataIter orig;
        DataSequenceHist dataSeq;

        DataIterHistory(DataIter orig) {
            this.orig = orig;
            this.dataSeq = new DataSequenceHist();
        }

        public void startScan() {
            this.orig.startScan();
        }

        public boolean hasNext() {
            return this.orig.hasNext();
        }

        public DataSequence next() {
            this.dataSeq.init(this.orig.next());
            return this.dataSeq;
        }
    }

    class DataSequenceHist
    implements DataSequence {
        Counters cntr;
        transient DataSequence orig;

        DataSequenceHist() {
            this.cntr = new Counters(HistoryManager.this.histsize, HistoryManager.this.numOrigY);
        }

        void init(DataSequence orig) {
            this.orig = orig;
        }

        public int length() {
            return this.orig.length();
        }

        public int y(int i) {
            this.cntr.clear();
            for (int k = HistoryManager.this.histsize - 1; k >= 0; --k) {
                if (i - k >= 0) {
                    this.cntr.fix(k, this.orig.y(i - k));
                    continue;
                }
                this.cntr.fix(k, 0);
            }
            return this.cntr.value();
        }

        public Object x(int i) {
            return this.orig.x(i);
        }

        public void set_y(int i, int label) {
        }
    }

    class FeatureGeneratorWithHistory
    implements FeatureGenerator {
        FeatureGenerator fgen;
        FeatureHist currentFeature;
        FeatureHist histFeature;
        boolean allDone;
        FeatureImpl feature = new FeatureImpl();

        FeatureGeneratorWithHistory(FeatureGenerator fgen) {
            this.fgen = fgen;
            this.histFeature = new FeatureHist(HistoryManager.this.histsize, HistoryManager.this.numOrigY);
        }

        public int numFeatures() {
            return this.fgen.numFeatures();
        }

        public void startScanFeaturesAt(DataSequence data, int pos) {
            this.fgen.startScanFeaturesAt(data, pos);
            this.allDone = false;
            if (this.fgen.hasNext()) {
                this.currentFeature = this.histFeature;
                this.currentFeature.init(this.fgen.next());
            } else {
                this.allDone = true;
            }
        }

        public boolean hasNext() {
            return !this.allDone;
        }

        public Feature next() {
            this.feature.copy(this.currentFeature);
            boolean nextY = this.currentFeature.advance();
            if (!nextY) {
                if (this.fgen.hasNext()) {
                    this.currentFeature.init(this.fgen.next());
                } else {
                    this.allDone = true;
                }
            }
            return this.feature;
        }

        public String featureName(int featureIndex) {
            return this.fgen.featureName(featureIndex);
        }
    }

    class FeatureHist
    implements Feature {
        Feature orig;
        Counters ctr;

        FeatureHist() {
        }

        FeatureHist(int histsize, int numOrigY) {
            this.ctr = new Counters(histsize + 1, numOrigY);
        }

        void init(Feature f) {
            this.orig = f;
            this.ctr.clear();
            this.ctr.fix(0, this.orig.y());
            this.ctr.fix(HistoryManager.this.histsize, 0);
            if (this.orig.yprev() != -1) {
                this.ctr.fix(1, this.orig.yprev());
            }
            if (this.orig.yprevArray() != null) {
                for (int i = 0; i < this.orig.yprevArray().length; ++i) {
                    if (this.orig.yprevArray()[i] == -1) continue;
                    this.ctr.fix(i + 1, this.orig.yprevArray()[i]);
                }
            }
        }

        boolean advance() {
            return this.ctr.advance();
        }

        public int index() {
            return this.orig.index();
        }

        public int y() {
            return this.ctr.value(HistoryManager.this.histsize - 1, 0);
        }

        public int yprev() {
            if (this.orig.yprevArray() == null || this.orig.yprevArray()[HistoryManager.this.histsize - 1] == -1) {
                return -1;
            }
            return this.ctr.value(HistoryManager.this.histsize, 1);
        }

        public int[] yprevArray() {
            return null;
        }

        public float value() {
            return this.orig.value();
        }

        String type() {
            return "H ";
        }

        void print() {
            System.out.println(this.type() + this.index() + " " + this.y() + " " + this.yprev() + " " + this.value());
        }
    }
}

