/*
 * Decompiled with CFR 0.152.
 */
package iitb.MaxentClassifier;

import iitb.CRF.CRF;
import iitb.CRF.FeatureGenerator;
import iitb.MaxentClassifier.DataDesc;
import iitb.MaxentClassifier.DataRecord;
import iitb.MaxentClassifier.DataSet;
import iitb.MaxentClassifier.FeatureGenRecord;
import iitb.MaxentClassifier.FileData;
import iitb.Utils.Options;
import java.io.IOException;

public class MaxentClassifier {
    FeatureGenRecord featureGen;
    CRF crfModel;
    DataDesc dataDesc;

    MaxentClassifier(Options opts) throws Exception {
        this.dataDesc = new DataDesc(opts);
        this.featureGen = new FeatureGenRecord(this.dataDesc.numColumns, this.dataDesc.numLabels);
        this.crfModel = new CRF(this.dataDesc.numLabels, (FeatureGenerator)this.featureGen, opts);
    }

    void train(String trainFile) throws IOException {
        double[] params = this.crfModel.train(new DataSet(FileData.read(trainFile, this.dataDesc)));
        System.out.println("Trained model");
        for (int i = 0; i < params.length; ++i) {
            System.out.println(this.featureGen.featureName(i) + " " + params[i]);
        }
    }

    void test(String testFile) throws IOException {
        FileData fData = new FileData();
        fData.openForRead(testFile, this.dataDesc);
        DataRecord dataRecord = new DataRecord(this.dataDesc.numColumns);
        int[][] confMat = new int[this.dataDesc.numLabels][this.dataDesc.numLabels];
        while (fData.readNext(dataRecord)) {
            int trueLabel = dataRecord.y();
            this.crfModel.apply(dataRecord);
            int[] nArray = confMat[trueLabel];
            int n = dataRecord.y();
            nArray[n] = nArray[n] + 1;
        }
        System.out.println("Confusion matrix ");
        for (int i = 0; i < this.dataDesc.numLabels; ++i) {
            System.out.print(i);
            for (int j = 0; j < this.dataDesc.numLabels; ++j) {
                System.out.print("\t" + confMat[i][j]);
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        try {
            Options opts = new Options(args);
            MaxentClassifier maxent = new MaxentClassifier(opts);
            maxent.train(opts.getMandatoryProperty("trainFile"));
            System.out.println("Finished training...Starting test");
            maxent.test(opts.getMandatoryProperty("testFile"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

