/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.Edge;
import iitb.Model.EdgeIterator;
import iitb.Model.Model;

public class CompleteModel
extends Model {
    public CompleteModel(int nlabels) {
        super(nlabels);
        this.name = "Complete";
    }

    public int numStates() {
        return this.numLabels;
    }

    public int label(int stateNum) {
        return stateNum;
    }

    public int numEdges() {
        return this.numLabels * this.numLabels;
    }

    public int numStartStates() {
        return this.numLabels;
    }

    public int numEndStates() {
        return this.numLabels;
    }

    public int startState(int i) {
        if (i < this.numStartStates()) {
            return i;
        }
        return -1;
    }

    public int endState(int i) {
        if (i < this.numEndStates()) {
            return i;
        }
        return -1;
    }

    public void stateMappings(DataSequence data) throws Exception {
    }

    public void stateMappings(DataSequence data, int len, int start) throws Exception {
    }

    public boolean isEndState(int i) {
        return true;
    }

    public boolean isStartState(int i) {
        return true;
    }

    public EdgeIterator edgeIterator() {
        return new SingleEdgeIterator(this);
    }

    public EdgeIterator innerEdgeIterator() {
        return null;
    }

    public class SingleEdgeIterator
    implements EdgeIterator {
        CompleteModel model;
        Edge edge;
        Edge edgeToReturn;

        SingleEdgeIterator(CompleteModel m) {
            this.model = m;
            this.edge = new Edge();
            this.edgeToReturn = new Edge();
            this.start();
        }

        public void start() {
            this.edge.start = 0;
            this.edge.end = 0;
        }

        public boolean hasNext() {
            return this.edge.start < this.model.numStates();
        }

        public Edge next() {
            this.edgeToReturn.start = this.edge.start++;
            this.edgeToReturn.end = this.edge.end++;
            if (this.edge.end == this.model.numStates()) {
                this.edge.end = 0;
            }
            return this.edgeToReturn;
        }

        public boolean nextIsOuter() {
            return true;
        }
    }
}

