/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ConcatRegexFeatures
extends FeatureTypes {
    String[][] patternString = new String[][]{{"isWord", "[a-zA-Z][a-zA-Z]+"}, {"singleCapLetterWithDot", "[A-Z]\\."}, {"singleCapLetter", "[A-Z]"}, {"isDigits", "\\d+"}, {"singleDot", "[.]"}, {"singleComma", "[,]"}, {"isSpecialCharacter", "[#;:\\-/<>'\"()&]"}, {"containsSpecialCharacters", ".*[#;:\\-/<>'\"()&].*"}, {"isInitCapital", "[A-Z][a-z]+"}, {"isAllCapital", "[A-Z]+"}, {"isAllSmallCase", "[a-z]+"}, {"isAlpha", "[a-zA-Z]+"}, {"isAlphaNumeric", "[a-zA-Z0-9]+"}, {"endsWithDot", "\\p{Alnum}+\\."}, {"endsWithComma", "\\w+[,]"}, {"endsWithPunctuation", "\\w+[;:,.?!]"}, {"singlePunctuation", "\\p{Punct}"}, {"singleAmp", "[&]"}, {"containsDigit", ".*\\d+.*"}, {"singleDigit", "\\s*\\d\\s*"}, {"twoDigits", "\\s*\\d{2}\\s*"}, {"threeDigits", "\\s*\\d{3}\\s*"}, {"fourDigits", "\\s*\\(*\\d{4}\\)*\\s*"}, {"isNumberRange", "\\d+\\s*([-]{1,2}\\s*\\d+)?"}, {"isDashSeparatedWords", "(\\w[-])+\\w"}, {"isDashSeparatedSeq", "((\\p{Alpha}+|\\p{Digit}+)[-])+(\\p{Alpha}+|\\p{Digit}+)"}, {"isURL", "\\p{Alpha}+://(\\w+\\.)\\w+(:(\\d{2}|\\d{4}))?(/\\w+)*(/|(/\\w+\\.\\w+))?"}, {"isEmailId", "\\w+@(\\w+\\.)+\\w+"}, {"containsDashes", ".*--.*"}};
    Pattern[] p;
    protected transient DataSequence data;
    protected int index;
    protected int idbase;
    protected int curId;
    protected int window;
    protected int relSegmentStart;
    protected int relSegmentEnd;
    protected int maxMemory;
    protected int left;
    protected int right;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConcatRegexFeatures(FeatureGenImpl fgen, int relSegmentStart, int relSegmentEnd, int maxMemory, String patternFile) {
        super(fgen);
        if (!$assertionsDisabled && relSegmentEnd < relSegmentStart) {
            throw new AssertionError();
        }
        this.relSegmentStart = relSegmentStart;
        this.relSegmentEnd = relSegmentEnd;
        this.maxMemory = maxMemory;
        this.window = this.getWindowSize(relSegmentStart, relSegmentEnd);
        this.idbase = (int)Math.pow(2.0, this.window);
        this.getPatterns(patternFile);
        if (!$assertionsDisabled && this.patternString == null) {
            throw new AssertionError();
        }
        this.p = new Pattern[this.patternString.length];
        for (int i = 0; i < this.patternString.length; ++i) {
            this.p[i] = Pattern.compile(this.patternString[i][1]);
        }
    }

    private int getWindowSize(int relSegmentStart, int relSegmentEnd) {
        if (this.sign(relSegmentEnd) == this.sign(relSegmentStart) && relSegmentStart != 0) {
            return relSegmentEnd - relSegmentStart + 1;
        }
        return relSegmentEnd - relSegmentStart + this.maxMemory;
    }

    public ConcatRegexFeatures(FeatureGenImpl m, int relSegmentStart, int relSegmentEnd, int maxMemory) {
        super(m);
        if (!$assertionsDisabled && relSegmentEnd < relSegmentStart) {
            throw new AssertionError();
        }
        this.relSegmentStart = relSegmentStart;
        this.relSegmentEnd = relSegmentEnd;
        this.maxMemory = maxMemory;
        this.window = this.getWindowSize(relSegmentStart, relSegmentEnd);
        this.idbase = (int)Math.pow(2.0, this.window);
        if (!$assertionsDisabled && this.patternString == null) {
            throw new AssertionError();
        }
        this.p = new Pattern[this.patternString.length];
        for (int i = 0; i < this.patternString.length; ++i) {
            this.p[i] = Pattern.compile(this.patternString[i][1]);
        }
    }

    public ConcatRegexFeatures(FeatureGenImpl m, int relSegmentStart, int relSegmentEnd) {
        this(m, relSegmentStart, relSegmentEnd, 1);
    }

    public ConcatRegexFeatures(FeatureGenImpl m, int relSegmentStart, int relSegmentEnd, String patternFile) {
        this(m, relSegmentStart, relSegmentEnd, 1, patternFile);
    }

    private int sign(int boundary) {
        if (boundary == 0) {
            return 0;
        }
        if (boundary < 0) {
            return -1;
        }
        return 1;
    }

    void getPatterns(String patternFile) {
        String[][] patterns;
        try {
            BufferedReader in = new BufferedReader(new FileReader(patternFile));
            int len = Integer.parseInt(in.readLine());
            patterns = new String[len][2];
            for (int k = 0; k < len; ++k) {
                StringTokenizer strTokenizer = new StringTokenizer(in.readLine());
                patterns[k][0] = strTokenizer.nextToken();
                patterns[k][1] = strTokenizer.nextToken();
            }
        }
        catch (IOException ioe) {
            System.err.println("Could not read pattern file : " + patternFile);
            ioe.printStackTrace();
            return;
        }
        this.patternString = patterns;
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        if (!$assertionsDisabled && this.patternString == null) {
            throw new AssertionError();
        }
        this.data = data;
        this.index = 0;
        this.left = this.relSegmentStart <= 0 ? prevPos + 1 + this.relSegmentStart : pos + this.relSegmentStart;
        this.right = this.relSegmentEnd < 0 ? prevPos + 1 + this.relSegmentEnd : pos + this.relSegmentEnd;
        if (this.left < 0 || this.left >= data.length() || this.right < 0 || this.right >= data.length()) {
            this.index = this.patternString.length;
        }
        this.advance();
        return true;
    }

    public boolean hasNext() {
        return this.index < this.patternString.length;
    }

    public void next(FeatureImpl f) {
        if (this.featureCollectMode()) {
            f.strId.name = this.patternString[this.index][0] + "_" + this.window + "_" + Integer.toBinaryString(this.curId);
        }
        f.val = 1.0f;
        f.strId.id = this.curId + this.idbase * this.index++;
        f.ystart = -1;
        this.advance();
    }

    private void advance() {
        this.curId = 0;
        while (this.curId <= 0 && this.index < this.patternString.length) {
            int base = 1;
            for (int k = this.left; k <= this.right; ++k) {
                boolean match = this.p[this.index].matcher((String)this.data.x(k)).matches();
                this.curId += base * (match ? 1 : 0);
                base *= 2;
            }
            if (this.curId > 0) break;
            ++this.index;
        }
    }

    public int maxFeatureId() {
        return this.idbase * (this.patternString.length - 1) + (this.idbase - 1);
    }

    int offsetLabelIndependentId(FeatureImpl f) {
        return f.strId.id;
    }

    static {
        $assertionsDisabled = !ConcatRegexFeatures.class.desiredAssertionStatus();
    }
}

