/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import gnu.trove.TIntArrayList;
import iitb.CRF.DataSequence;
import iitb.Model.Edge;
import iitb.Model.EdgeIterator;
import iitb.Model.Model;
import java.util.Arrays;
import java.util.BitSet;
import java.util.StringTokenizer;

public class GenericModel
extends Model {
    int _numStates;
    Edge[] _edges;
    int[] edgeStart;
    int[] startStates;
    int[] endStates;
    int myLabel = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int label(int s) {
        return this.myLabel == -1 ? s : this.myLabel;
    }

    public GenericModel(String spec, int thisLabel) throws Exception {
        super(1);
        this.name = spec;
        this.myLabel = thisLabel;
        if (spec.endsWith("-chain") || spec.endsWith("-long")) {
            int len;
            StringTokenizer tok = new StringTokenizer(spec, "-");
            this._numStates = len = Integer.parseInt(tok.nextToken());
            this.startStates = new int[1];
            this.startStates[0] = 0;
            this.edgeStart = new int[this._numStates];
            if (len == 1) {
                this._edges = new Edge[1];
                this._edges[0] = new Edge(0, 0);
                this.endStates = new int[1];
                this.endStates[0] = 0;
                this.edgeStart[0] = 0;
            } else {
                this._edges = new Edge[2 * (len - 1)];
                for (int i = 0; i < len - 1; ++i) {
                    this._edges[2 * i] = new Edge(i, i + 1);
                    this._edges[2 * i + 1] = new Edge(i, len - 1);
                    this.edgeStart[i] = 2 * i;
                }
                this._edges[this._edges.length - 1] = new Edge(len - 2, len - 2);
                this.endStates = new int[2];
                this.endStates[0] = 0;
                this.endStates[1] = len - 1;
            }
        } else if (spec.endsWith("parallel")) {
            StringTokenizer tok = new StringTokenizer(spec, "-");
            int len = Integer.parseInt(tok.nextToken());
            this._numStates = len * (len + 1) / 2;
            this._edges = new Edge[len * (len - 1) / 2 + 1];
            this.edgeStart = new int[this._numStates];
            this.startStates = new int[len];
            this.endStates = new int[len];
            int node = 0;
            int e = 0;
            for (int i = 0; i < len; ++i) {
                node += i;
                for (int j = 0; j < i; ++j) {
                    this._edges[e++] = new Edge(node + j, node + j + 1);
                    this.edgeStart[node + j] = e - 1;
                }
                this.startStates[i] = node;
                this.endStates[i] = node + i;
            }
            node += len;
            this._edges[e++] = new Edge(this._numStates - 2, this._numStates - 2);
            if (!$assertionsDisabled && e != this._edges.length) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && node != this._numStates) {
                throw new AssertionError();
            }
        } else if (spec.equals("boundary")) {
            this._numStates = 4;
            this._edges = new Edge[4];
            this._edges[0] = new Edge(1, 2);
            this._edges[1] = new Edge(1, 3);
            this._edges[2] = new Edge(2, 2);
            this._edges[3] = new Edge(2, 3);
            this.startStates = new int[2];
            this.startStates[0] = 0;
            this.startStates[1] = 1;
            this.endStates = new int[2];
            this.endStates[0] = 0;
            this.endStates[1] = 3;
            this.edgeStart = new int[this._numStates];
            this.edgeStart[0] = 4;
            this.edgeStart[1] = 0;
            this.edgeStart[2] = 2;
            this.edgeStart[3] = 4;
        } else {
            throw new Exception("Unknown graph type: " + spec);
        }
    }

    public void setEdgeStartPointers() {
        int i;
        Arrays.sort(this._edges);
        this.edgeStart = new int[this._numStates];
        for (i = 0; i < this.edgeStart.length; ++i) {
            this.edgeStart[i] = this._numStates;
        }
        for (i = 0; i < this._edges.length; ++i) {
            if (this.edgeStart[this._edges[i].start] <= i) continue;
            this.edgeStart[this._edges[i].start] = i;
        }
    }

    public void fillStartEnd() {
        int i;
        BitSet isStart = new BitSet(this._numStates);
        BitSet isEnd = new BitSet(this._numStates);
        isStart.flip(0, this._numStates);
        isEnd.flip(0, this._numStates);
        for (int i2 = 0; i2 < this._edges.length; ++i2) {
            isStart.set(this._edges[i2].end, false);
            isEnd.set(this._edges[i2].start, false);
        }
        this.startStates = new int[isStart.cardinality()];
        int prev = 0;
        for (i = 0; i < this.startStates.length; ++i) {
            this.startStates[i] = isStart.nextSetBit(prev);
            prev = this.startStates[i] + 1;
        }
        this.endStates = new int[isEnd.cardinality()];
        prev = 0;
        for (i = 0; i < this.endStates.length; ++i) {
            this.endStates[i] = isEnd.nextSetBit(prev);
            prev = this.endStates[i] + 1;
        }
    }

    public void setEdges(Object[] edges) {
        this._edges = new Edge[edges.length];
        for (int i = 0; i < this._edges.length; ++i) {
            this._edges[i] = (Edge)edges[i];
        }
    }

    public void addEdge(int edgeNum, int st, int end) {
        this._edges[edgeNum] = new Edge(st, end);
    }

    public GenericModel(int numNodes, int numEdges) throws Exception {
        super(numNodes);
        this._numStates = numNodes;
        this._edges = new Edge[numEdges];
    }

    public int numStates() {
        return this._numStates;
    }

    public int numEdges() {
        return this._edges.length;
    }

    public int numStartStates() {
        return this.startStates.length;
    }

    public int startState(int i) {
        return i < this.numStartStates() ? this.startStates[i] : -1;
    }

    public int numEndStates() {
        return this.endStates.length;
    }

    public int endState(int i) {
        return i < this.numEndStates() ? this.endStates[i] : -1;
    }

    public boolean isEndState(int i) {
        for (int k = 0; k < this.endStates.length; ++k) {
            if (this.endStates[k] != i) continue;
            return true;
        }
        return false;
    }

    public boolean isStartState(int i) {
        for (int k = 0; k < this.startStates.length; ++k) {
            if (this.startStates[k] != i) continue;
            return true;
        }
        return false;
    }

    public void stateMappings(DataSequence data) throws Exception {
    }

    public void stateMappings(DataSequence data, int len, int start) throws Exception {
        for (int i = 0; i < this.numStartStates(); ++i) {
            if (!this.pathToEnd(data, this.startState(i), len - 1, start + 1)) continue;
            data.set_y(start, this.startState(i));
            return;
        }
        throw new Exception("No path in graph");
    }

    boolean pathToEnd(DataSequence data, int s, int lenLeft, int start) {
        if (lenLeft == 0) {
            return this.isEndState(s);
        }
        for (int e = this.edgeStart[s]; e < this.numEdges() && this._edges[e].start == s; ++e) {
            int child = this._edges[e].end;
            if (!this.pathToEnd(data, child, lenLeft - 1, start + 1)) continue;
            data.set_y(start, child);
            return true;
        }
        return false;
    }

    public int stateMappingGivenLength(int label, int len, int posFromStart) throws Exception {
        for (int i = 0; i < this.numStartStates(); ++i) {
            int stateId = this.pathToEnd(this.startState(i), len - 1, posFromStart - 1);
            if (stateId < 0) continue;
            if (posFromStart == 0) {
                return this.startState(i);
            }
            return stateId;
        }
        throw new Exception("No path in graph");
    }

    public void stateMappingGivenLength(int label, int len, TIntArrayList stateIds) throws Exception {
        int i;
        stateIds.clear();
        for (i = 0; i < len; ++i) {
            stateIds.add(0);
        }
        for (i = 0; i < this.numStartStates(); ++i) {
            if (!this.pathToEnd(this.startState(i), len - 1, 1, stateIds)) continue;
            stateIds.setQuick(0, this.startState(i));
            return;
        }
        throw new Exception("No path in graph");
    }

    boolean pathToEnd(int s, int lenLeft, int start, TIntArrayList stateIds) {
        if (!$assertionsDisabled && lenLeft < 0) {
            throw new AssertionError();
        }
        if (lenLeft == 0) {
            return this.isEndState(s);
        }
        for (int e = this.edgeStart[s]; e < this.numEdges() && this._edges[e].start == s; ++e) {
            int child = this._edges[e].end;
            if (!this.pathToEnd(child, lenLeft - 1, start + 1, stateIds)) continue;
            stateIds.setQuick(start, child);
            return true;
        }
        return false;
    }

    private int pathToEnd(int s, int lenLeft, int posFromStart) {
        if (lenLeft == 0) {
            return this.isEndState(s) ? s : -1;
        }
        for (int e = this.edgeStart[s]; e < this.numEdges() && this._edges[e].start == s; ++e) {
            int child = this._edges[e].end;
            int stateId = this.pathToEnd(child, lenLeft - 1, posFromStart - 1);
            if (stateId < 0) continue;
            if (posFromStart == 0) {
                return child;
            }
            return stateId;
        }
        return -1;
    }

    public EdgeIterator edgeIterator() {
        return new GenericEdgeIterator(this._edges);
    }

    static {
        $assertionsDisabled = !GenericModel.class.desiredAssertionStatus();
    }

    public class GenericEdgeIterator
    implements EdgeIterator {
        int edgeNum;
        Edge[] edges;

        GenericEdgeIterator(Edge[] e) {
            this.edges = e;
            this.start();
        }

        public void start() {
            this.edgeNum = 0;
        }

        public boolean hasNext() {
            return this.edgeNum < this.edges.length;
        }

        public Edge next() {
            ++this.edgeNum;
            return this.edges[this.edgeNum - 1];
        }

        public boolean nextIsOuter() {
            return true;
        }
    }
}

