/*
 * Decompiled with CFR 0.152.
 */
package iitb.Model;

import iitb.CRF.DataSequence;
import iitb.Model.FeatureGenImpl;
import iitb.Model.FeatureImpl;
import iitb.Model.FeatureTypes;
import iitb.Model.WordsInTrain;

public class WordFeatures
extends FeatureTypes {
    int stateId;
    int statePos;
    Object token;
    int tokenId;
    WordsInTrain dict;
    int _numWordStatePairs;
    public static int RARE_THRESHOLD = 0;

    public WordFeatures(FeatureGenImpl m, WordsInTrain d) {
        super(m);
        this.dict = d;
    }

    private void nextStateId() {
        this.stateId = this.dict.nextStateWithWord(this.token, this.stateId);
        ++this.statePos;
    }

    public boolean startScanFeaturesAt(DataSequence data, int prevPos, int pos) {
        this.stateId = -1;
        if (this.dict.count(data.x(pos)) > RARE_THRESHOLD) {
            this.token = data.x(pos);
            this.tokenId = this.dict.getIndex(this.token);
            this.statePos = -1;
            this.nextStateId();
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        return this.stateId != -1;
    }

    public void next(FeatureImpl f) {
        if (this.featureCollectMode()) {
            this.setFeatureIdentifier(this.tokenId * this.model.numStates() + this.stateId, this.stateId, "W_" + this.token, f);
        } else {
            this.setFeatureIdentifier(this.tokenId * this.model.numStates() + this.stateId, this.stateId, this.token, f);
        }
        f.yend = this.stateId;
        f.ystart = -1;
        f.val = 1.0f;
        this.nextStateId();
    }

    public int maxFeatureId() {
        return this.dict.dictionaryLength() * this.model.numStates();
    }
}

