/*
 * Decompiled with CFR 0.152.
 */
package iitb.Segment;

import iitb.CRF.CRF;
import iitb.CRF.FeatureGenerator;
import iitb.CRF.FeatureGeneratorNested;
import iitb.CRF.NestedCRF;
import iitb.CRF.SegmentDataSequence;
import iitb.CRF.Util;
import iitb.Model.FeatureGenImpl;
import iitb.Model.NestedFeatureGenImpl;
import iitb.Segment.AlphaNumericPreprocessor;
import iitb.Segment.BinaryLabelMap;
import iitb.Segment.DataCruncher;
import iitb.Segment.LabelMap;
import iitb.Segment.TestData;
import iitb.Segment.TestDataWrite;
import iitb.Segment.TrainData;
import iitb.Segment.TrainRecord;
import iitb.Utils.Options;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Segment {
    String inName;
    String outDir;
    String baseDir = "";
    int nlabels;
    String delimit = " \t";
    String tagDelimit = "|";
    String impDelimit = "";
    String groupDelimit = null;
    boolean[] confuseSet = null;
    boolean validate = false;
    String mapTagString = null;
    String smoothType = "";
    String modelArgs = "";
    String featureArgs = "";
    String modelGraphType = "naive";
    LabelMap labelMap;
    Options options;
    CRF crfModel;
    FeatureGenImpl featureGen;
    TrainData taggedData = null;

    public FeatureGenerator featureGenerator() {
        return this.featureGen;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 3) {
            System.out.println("Usage: java Tagger train|test|calc -f <conf-file>");
            return;
        }
        Segment segment = new Segment();
        segment.parseConf(argv);
        if (argv[0].toLowerCase().equals("all")) {
            segment.train();
            segment.doTest();
            segment.calc();
        }
        if (argv[0].toLowerCase().equals("train")) {
            segment.train();
        }
        if (argv[0].toLowerCase().equals("test")) {
            segment.test();
        }
        if (argv[0].toLowerCase().equals("calc")) {
            segment.calc();
        }
    }

    public void parseConf(String[] argv) throws Exception {
        this.options = new Options();
        boolean startIndex = true;
        if (argv.length >= 2 && argv[1].toLowerCase().equals("-f")) {
            this.options.load(new FileInputStream(argv[2]));
        }
        this.options.add(3, argv);
        this.processArgs();
    }

    public void processArgs() throws Exception {
        String value = null;
        value = this.options.getMandatoryProperty("numlabels");
        if (value != null) {
            this.nlabels = Integer.parseInt(value);
        }
        if ((value = this.options.getProperty("binary")) != null) {
            this.nlabels = 2;
            this.labelMap = new BinaryLabelMap(this.options.getInt("binary"));
        } else {
            this.labelMap = new LabelMap();
        }
        value = this.options.getMandatoryProperty("inname");
        if (value != null) {
            this.inName = new String(value);
        }
        if ((value = this.options.getMandatoryProperty("outdir")) != null) {
            this.outDir = new String(value);
        }
        if ((value = this.options.getProperty("basedir")) != null) {
            this.baseDir = new String(value);
        }
        if ((value = this.options.getProperty("tagdelimit")) != null) {
            this.tagDelimit = new String(value);
        }
        if ((value = this.options.getProperty("delimit")) != null) {
            this.delimit = new String(value);
        }
        if ((value = this.options.getProperty("impdelimit")) != null) {
            this.impDelimit = new String(value);
        }
        if ((value = this.options.getProperty("groupdelimit")) != null) {
            this.groupDelimit = value;
        }
        if ((value = this.options.getProperty("confusion")) != null) {
            StringTokenizer confuse = new StringTokenizer(value, ", ");
            int confuseSize = confuse.countTokens();
            this.confuseSet = new boolean[this.nlabels + 1];
            for (int i = 0; i < confuseSize; ++i) {
                this.confuseSet[Integer.parseInt((String)confuse.nextToken())] = true;
            }
        }
        if ((value = this.options.getProperty("map-tags")) != null) {
            this.mapTagString = value;
        }
        if ((value = this.options.getProperty("validate")) != null) {
            this.validate = true;
        }
        if ((value = this.options.getProperty("model-args")) != null) {
            this.modelArgs = value;
            System.out.println(this.modelArgs);
        }
        if ((value = this.options.getProperty("feature-args")) != null) {
            this.featureArgs = value;
        }
        if ((value = this.options.getProperty("modelGraph")) != null) {
            this.modelGraphType = value;
        }
    }

    void allocModel() throws Exception {
        if (this.modelGraphType.equals("semi-markov")) {
            if (this.options.getInt("debugLvl") > 1) {
                Util.printDbg("Creating semi-markov model");
            }
            NestedFeatureGenImpl nfgen = new NestedFeatureGenImpl(this.nlabels, this.options);
            this.featureGen = nfgen;
            this.crfModel = new NestedCRF(this.featureGen.numStates(), (FeatureGeneratorNested)nfgen, (Properties)this.options);
        } else {
            this.featureGen = new FeatureGenImpl(this.modelGraphType, this.nlabels);
            this.crfModel = new CRF(this.featureGen.numStates(), (FeatureGenerator)this.featureGen, this.options);
        }
    }

    public int[] segment(TestRecord testRecord, int[] groupedToks, String[] collect) {
        int i;
        for (int i2 = 0; i2 < testRecord.length(); ++i2) {
            testRecord.seq[i2] = AlphaNumericPreprocessor.preprocess(testRecord.seq[i2]);
        }
        this.crfModel.apply(testRecord);
        this.featureGen.mapStatesToLabels(testRecord);
        int[] path = testRecord.path;
        for (i = 0; i < this.nlabels; ++i) {
            collect[i] = null;
        }
        for (i = 0; i < testRecord.length(); ++i) {
            int snew = path[i];
            if (snew < 0) continue;
            collect[snew] = collect[snew] == null ? testRecord.seq[i] : collect[snew] + " " + testRecord.seq[i];
        }
        return path;
    }

    public void train() throws Exception {
        DataCruncher.createRaw(this.baseDir + "/data/" + this.inName + "/" + this.inName + ".train", this.tagDelimit);
        File dir = new File(this.baseDir + "/learntModels/" + this.outDir);
        dir.mkdirs();
        TrainData trainData = DataCruncher.readTagged(this.nlabels, this.baseDir + "/data/" + this.inName + "/" + this.inName + ".train", this.baseDir + "/data/" + this.inName + "/" + this.inName + ".train", this.delimit, this.tagDelimit, this.impDelimit, this.labelMap);
        AlphaNumericPreprocessor.preprocess(trainData, this.nlabels);
        this.allocModel();
        this.featureGen.train(trainData);
        double[] featureWts = this.crfModel.train(trainData);
        if (this.options.getInt("debugLvl") > 1) {
            Util.printDbg("Training done");
        }
        this.crfModel.write(this.baseDir + "/learntModels/" + this.outDir + "/crf");
        this.featureGen.write(this.baseDir + "/learntModels/" + this.outDir + "/features");
        if (this.options.getInt("debugLvl") > 1) {
            Util.printDbg("Writing model to " + this.baseDir + "/learntModels/" + this.outDir + "/crf");
        }
        if (this.options.getProperty("showModel") != null) {
            this.featureGen.displayModel(featureWts);
        }
    }

    public void test() throws Exception {
        this.allocModel();
        this.featureGen.read(this.baseDir + "/learntModels/" + this.outDir + "/features");
        this.crfModel.read(this.baseDir + "/learntModels/" + this.outDir + "/crf");
        this.doTest();
    }

    public void doTest() throws Exception {
        File dir = new File(this.baseDir + "/out/" + this.outDir);
        dir.mkdirs();
        TestData testData = new TestData(this.baseDir + "/data/" + this.inName + "/" + this.inName + ".test", this.delimit, this.impDelimit, this.groupDelimit);
        TestDataWrite tdw = new TestDataWrite(this.baseDir + "/out/" + this.outDir + "/" + this.inName + ".test", this.baseDir + "/data/" + this.inName + "/" + this.inName + ".test", this.delimit, this.tagDelimit, this.impDelimit, this.labelMap);
        String[] collect = new String[this.nlabels];
        TestRecord testRecord = new TestRecord(collect);
        String[] seq = testData.nextRecord();
        while (seq != null) {
            testRecord.init(seq);
            if (this.options.getInt("debugLvl") > 1) {
                Util.printDbg("Invoking segment on " + seq);
            }
            int[] path = this.segment(testRecord, testData.groupedTokens(), collect);
            tdw.writeRecord(path, testRecord.length());
            seq = testData.nextRecord();
        }
        tdw.close();
    }

    int[] allLabels(TrainRecord tr) {
        int[] labs = new int[tr.length()];
        for (int i = 0; i < labs.length; ++i) {
            labs[i] = tr.y(i);
        }
        return labs;
    }

    String arrayToString(Object[] ar) {
        String st = "";
        for (int i = 0; i < ar.length; ++i) {
            st = st + ar[i] + " ";
        }
        return st;
    }

    public void calc() throws Exception {
        int i;
        boolean printDetails;
        Vector s = new Vector();
        TrainData tdMan = DataCruncher.readTagged(this.nlabels, this.baseDir + "/data/" + this.inName + "/" + this.inName + ".test", this.baseDir + "/data/" + this.inName + "/" + this.inName + ".test", this.delimit, this.tagDelimit, this.impDelimit, this.labelMap);
        TrainData tdAuto = DataCruncher.readTagged(this.nlabels, this.baseDir + "/out/" + this.outDir + "/" + this.inName + ".test", this.baseDir + "/data/" + this.inName + "/" + this.inName + ".test", this.delimit, this.tagDelimit, this.impDelimit, this.labelMap);
        DataCruncher.readRaw(s, this.baseDir + "/data/" + this.inName + "/" + this.inName + ".test", "", "");
        int len = tdAuto.size();
        int[] truePos = new int[this.nlabels + 1];
        int[] totalMarkedPos = new int[this.nlabels + 1];
        int[] totalPos = new int[this.nlabels + 1];
        int[][] confuseMatrix = new int[this.nlabels][this.nlabels];
        boolean bl = printDetails = this.options.getInt("debugLvl") > 0;
        if (tdAuto.size() != tdMan.size()) {
            System.out.println("Length Mismatch - Raw: " + len + " Auto: " + tdAuto.size() + " Man: " + tdMan.size());
        }
        for (i = 0; i < len; ++i) {
            int j;
            int[] tokenAuto;
            String[] raw = (String[])s.get(i);
            TrainRecord trMan = tdMan.nextRecord();
            TrainRecord trAuto = tdAuto.nextRecord();
            int[] tokenMan = this.allLabels(trMan);
            if (tokenMan.length != (tokenAuto = this.allLabels(trAuto)).length) {
                System.out.println("Length Mismatch - Manual: " + tokenMan.length + " Auto: " + tokenAuto.length);
            }
            boolean invalidMatch = false;
            int tlen = tokenMan.length;
            for (int j2 = 0; j2 < tlen; ++j2) {
                if (printDetails) {
                    System.err.println(tokenMan[j2] + " " + tokenAuto[j2]);
                }
                if (tokenAuto[j2] >= 0) continue;
                invalidMatch = true;
                break;
            }
            if (invalidMatch) {
                if (!printDetails) continue;
                System.err.println("No valid path");
                continue;
            }
            int correctTokens = 0;
            for (int j3 = 0; j3 < tlen; ++j3) {
                int n = tokenAuto[j3];
                totalMarkedPos[n] = totalMarkedPos[n] + 1;
                int n2 = this.nlabels;
                totalMarkedPos[n2] = totalMarkedPos[n2] + 1;
                int n3 = tokenMan[j3];
                totalPos[n3] = totalPos[n3] + 1;
                int n4 = this.nlabels;
                totalPos[n4] = totalPos[n4] + 1;
                int[] nArray = confuseMatrix[tokenMan[j3]];
                int n5 = tokenAuto[j3];
                nArray[n5] = nArray[n5] + 1;
                if (tokenAuto[j3] != tokenMan[j3]) continue;
                ++correctTokens;
                int n6 = tokenMan[j3];
                truePos[n6] = truePos[n6] + 1;
                int n7 = this.nlabels;
                truePos[n7] = truePos[n7] + 1;
            }
            if (printDetails) {
                System.err.println("Stats: " + correctTokens + " " + tlen);
            }
            int rlen = raw.length;
            for (j = 0; j < rlen; ++j) {
                if (!printDetails) continue;
                System.err.print(raw[j] + " ");
            }
            if (printDetails) {
                System.err.println();
            }
            for (j = 0; j < this.nlabels; ++j) {
                String mstr = "";
                for (int k = 0; k < trMan.numSegments(j); ++k) {
                    mstr = mstr + this.arrayToString(trMan.tokens(j, k));
                }
                String astr = "";
                for (int k = 0; k < trAuto.numSegments(j); ++k) {
                    astr = astr + this.arrayToString(trAuto.tokens(j, k));
                }
                if (!mstr.equalsIgnoreCase(astr) && printDetails) {
                    System.err.print("W");
                }
                if (!printDetails) continue;
                System.err.println(j + ": " + mstr + " : " + astr);
            }
            if (!printDetails) continue;
            System.err.println();
        }
        if (this.confuseSet != null) {
            System.out.println("Confusion Matrix:");
            System.out.print("M\\A");
            for (i = 0; i < this.nlabels; ++i) {
                if (!this.confuseSet[i]) continue;
                System.out.print("\t" + i);
            }
            System.out.println();
            for (i = 0; i < this.nlabels; ++i) {
                if (!this.confuseSet[i]) continue;
                System.out.print(i);
                for (int j = 0; j < this.nlabels; ++j) {
                    if (!this.confuseSet[j]) continue;
                    System.out.print("\t" + confuseMatrix[i][j]);
                }
                System.out.println();
            }
        }
        System.out.println("\n\nCalculations:");
        System.out.println();
        System.out.println("Label\tTrue+\tMarked+\tActual+\tPrec.\tRecall\tF1");
        for (int i2 = 0; i2 < this.nlabels; ++i2) {
            double prec = totalMarkedPos[i2] == 0 ? 0.0 : (double)(truePos[i2] * 100000 / totalMarkedPos[i2]) / 1000.0;
            double recall = totalPos[i2] == 0 ? 0.0 : (double)(truePos[i2] * 100000 / totalPos[i2]) / 1000.0;
            System.out.println(i2 + ":\t" + truePos[i2] + "\t" + totalMarkedPos[i2] + "\t" + totalPos[i2] + "\t" + prec + "\t" + recall + "\t" + 2.0 * prec * recall / (prec + recall));
        }
        System.out.println("---------------------------------------------------------");
        double prec = totalMarkedPos[this.nlabels] == 0 ? 0.0 : (double)(truePos[this.nlabels] * 100000 / totalMarkedPos[this.nlabels]) / 1000.0;
        double recall = totalPos[this.nlabels] == 0 ? 0.0 : (double)(truePos[this.nlabels] * 100000 / totalPos[this.nlabels]) / 1000.0;
        System.out.println("Ov:\t" + truePos[this.nlabels] + "\t" + totalMarkedPos[this.nlabels] + "\t" + totalPos[this.nlabels] + "\t" + prec + "\t" + recall + "\t" + 2.0 * prec * recall / (prec + recall));
    }

    class TestRecord
    implements SegmentDataSequence {
        String[] seq;
        int[] path;

        TestRecord(String[] s) {
            this.seq = s;
            this.path = new int[this.seq.length];
        }

        void init(String[] s) {
            this.seq = s;
            if (this.path == null || this.path.length < this.seq.length) {
                this.path = new int[this.seq.length];
            }
        }

        public void set_y(int i, int l) {
            this.path[i] = l;
        }

        public int y(int i) {
            return this.path[i];
        }

        public int length() {
            return this.seq.length;
        }

        public Object x(int i) {
            return this.seq[i];
        }

        public int getSegmentEnd(int segmentStart) {
            if (segmentStart > 0 && this.y(segmentStart) == this.y(segmentStart - 1)) {
                return -1;
            }
            for (int i = segmentStart + 1; i < this.length(); ++i) {
                if (this.y(i) == this.y(segmentStart)) continue;
                return i - 1;
            }
            return this.length() - 1;
        }

        public void setSegment(int segmentStart, int segmentEnd, int y) {
            for (int i = segmentStart; i <= segmentEnd; ++i) {
                this.set_y(i, y);
            }
        }
    }
}

