/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Insets;
import java.text.DateFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.JFreeChartConstants;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.Timeline;
import org.jfree.chart.labels.HighLowToolTipGenerator;
import org.jfree.chart.labels.IntervalCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardPieItemLabelGenerator;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.StandardXYZToolTipGenerator;
import org.jfree.chart.labels.TimeSeriesToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Pie3DPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AreaRenderer;
import org.jfree.chart.renderer.AreaXYRenderer;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.BarRenderer3D;
import org.jfree.chart.renderer.CandlestickRenderer;
import org.jfree.chart.renderer.GanttRenderer;
import org.jfree.chart.renderer.HighLowRenderer;
import org.jfree.chart.renderer.LineAndShapeRenderer;
import org.jfree.chart.renderer.SignalRenderer;
import org.jfree.chart.renderer.StackedAreaRenderer;
import org.jfree.chart.renderer.StackedAreaXYRenderer;
import org.jfree.chart.renderer.StackedBarRenderer;
import org.jfree.chart.renderer.StackedBarRenderer3D;
import org.jfree.chart.renderer.StandardXYItemRenderer;
import org.jfree.chart.renderer.WindItemRenderer;
import org.jfree.chart.renderer.XYBarRenderer;
import org.jfree.chart.renderer.XYBoxAndWhiskerRenderer;
import org.jfree.chart.renderer.XYBubbleRenderer;
import org.jfree.chart.renderer.XYStepRenderer;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.chart.urls.StandardPieURLGenerator;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.StandardXYZURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.PieDataset;
import org.jfree.data.SignalsDataset;
import org.jfree.data.TableXYDataset;
import org.jfree.data.WindDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XYZDataset;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;

public abstract class ChartFactory {
    public static JFreeChart createPieChart(String string2, PieDataset pieDataset, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setInsets(new Insets(0, 5, 5, 5));
        StandardPieItemLabelGenerator standardPieItemLabelGenerator = null;
        if (bl2) {
            standardPieItemLabelGenerator = new StandardPieItemLabelGenerator();
        }
        StandardPieURLGenerator standardPieURLGenerator = null;
        if (bl3) {
            standardPieURLGenerator = new StandardPieURLGenerator();
        }
        piePlot.setItemLabelGenerator(standardPieItemLabelGenerator);
        piePlot.setURLGenerator(standardPieURLGenerator);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, piePlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string2, CategoryDataset categoryDataset, int n, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot = new PiePlot(categoryDataset, n);
        piePlot.setInsets(new Insets(0, 5, 5, 5));
        StandardPieItemLabelGenerator standardPieItemLabelGenerator = null;
        if (bl2) {
            standardPieItemLabelGenerator = new StandardPieItemLabelGenerator();
        }
        StandardPieURLGenerator standardPieURLGenerator = null;
        if (bl3) {
            standardPieURLGenerator = new StandardPieURLGenerator();
        }
        piePlot.setItemLabelGenerator(standardPieItemLabelGenerator);
        piePlot.setURLGenerator(standardPieURLGenerator);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, piePlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createPie3DChart(String string2, PieDataset pieDataset, boolean bl, boolean bl2, boolean bl3) {
        Pie3DPlot pie3DPlot = new Pie3DPlot(pieDataset);
        pie3DPlot.setInsets(new Insets(0, 5, 5, 5));
        StandardPieItemLabelGenerator standardPieItemLabelGenerator = null;
        if (bl2) {
            standardPieItemLabelGenerator = new StandardPieItemLabelGenerator();
        }
        StandardPieURLGenerator standardPieURLGenerator = null;
        if (bl3) {
            standardPieURLGenerator = new StandardPieURLGenerator();
        }
        pie3DPlot.setItemLabelGenerator(standardPieItemLabelGenerator);
        pie3DPlot.setURLGenerator(standardPieURLGenerator);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, pie3DPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createAreaChart(String string2, String string3, String string4, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis categoryAxis = new CategoryAxis(string3);
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis numberAxis = new NumberAxis(string4);
        AreaRenderer areaRenderer = new AreaRenderer();
        if (bl2) {
            areaRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        }
        if (bl3) {
            areaRenderer.setItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, areaRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedAreaChart(String string2, String string3, String string4, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis categoryAxis = new CategoryAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        StackedAreaRenderer stackedAreaRenderer = new StackedAreaRenderer();
        if (bl2) {
            stackedAreaRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        }
        if (bl3) {
            stackedAreaRenderer.setItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, stackedAreaRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createBarChart(String string2, String string3, String string4, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis categoryAxis = new CategoryAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        BarRenderer barRenderer = new BarRenderer();
        if (bl2) {
            barRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        }
        if (bl3) {
            barRenderer.setItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, barRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedBarChart(String string2, String string3, String string4, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis categoryAxis = new CategoryAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        StackedBarRenderer stackedBarRenderer = new StackedBarRenderer();
        if (bl2) {
            stackedBarRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        }
        if (bl3) {
            stackedBarRenderer.setItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, stackedBarRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createBarChart3D(String string2, String string3, String string4, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis3D categoryAxis3D = new CategoryAxis3D(string3);
        NumberAxis3D numberAxis3D = new NumberAxis3D(string4);
        BarRenderer3D barRenderer3D = new BarRenderer3D();
        if (bl2) {
            barRenderer3D.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        }
        if (bl3) {
            barRenderer3D.setItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis3D, numberAxis3D, barRenderer3D);
        categoryPlot.setOrientation(plotOrientation);
        categoryPlot.setForegroundAlpha(0.75f);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedBarChart3D(String string2, String string3, String string4, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis3D categoryAxis3D = new CategoryAxis3D(string3);
        NumberAxis3D numberAxis3D = new NumberAxis3D(string4);
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = null;
        if (bl2) {
            standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        StackedBarRenderer3D stackedBarRenderer3D = new StackedBarRenderer3D();
        stackedBarRenderer3D.setItemLabelGenerator(standardCategoryItemLabelGenerator);
        stackedBarRenderer3D.setItemURLGenerator(standardCategoryURLGenerator);
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis3D, numberAxis3D, stackedBarRenderer3D);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createLineChart(String string2, String string3, String string4, CategoryDataset categoryDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis categoryAxis = new CategoryAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        lineAndShapeRenderer.setDrawLines(true);
        lineAndShapeRenderer.setDrawShapes(false);
        if (bl2) {
            lineAndShapeRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        }
        if (bl3) {
            lineAndShapeRenderer.setItemURLGenerator(new StandardCategoryURLGenerator());
        }
        CategoryPlot categoryPlot = new CategoryPlot(categoryDataset, categoryAxis, numberAxis, lineAndShapeRenderer);
        categoryPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createGanttChart(String string2, String string3, String string4, IntervalCategoryDataset intervalCategoryDataset, boolean bl, boolean bl2, boolean bl3) {
        CategoryAxis categoryAxis = new CategoryAxis(string3);
        DateAxis dateAxis = new DateAxis(string4);
        IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator = null;
        if (bl2) {
            intervalCategoryItemLabelGenerator = new IntervalCategoryItemLabelGenerator(DateFormat.getDateInstance());
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        GanttRenderer ganttRenderer = new GanttRenderer();
        ganttRenderer.setItemLabelGenerator(intervalCategoryItemLabelGenerator);
        ganttRenderer.setItemURLGenerator(standardCategoryURLGenerator);
        CategoryPlot categoryPlot = new CategoryPlot(intervalCategoryDataset, categoryAxis, dateAxis, ganttRenderer);
        categoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, categoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createLineXYChart(String string2, String string3, String string4, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        return ChartFactory.createXYLineChart(string2, string3, string4, xYDataset, plotOrientation, bl, bl2, bl3);
    }

    public static JFreeChart createXYLineChart(String string2, String string3, String string4, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string4);
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(2);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, standardXYItemRenderer);
        xYPlot.setOrientation(plotOrientation);
        if (bl2) {
            standardXYItemRenderer.setToolTipGenerator(new StandardXYToolTipGenerator());
        }
        if (bl3) {
            standardXYItemRenderer.setURLGenerator(new StandardXYURLGenerator());
        }
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createAreaXYChart(String string2, String string3, String string4, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        return ChartFactory.createXYAreaChart(string2, string3, string4, xYDataset, plotOrientation, bl, bl2, bl3);
    }

    public static JFreeChart createXYAreaChart(String string2, String string3, String string4, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string4);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        xYPlot.setOrientation(plotOrientation);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new AreaXYRenderer(4, standardXYToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createScatterPlot(String string2, String string3, String string4, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string4);
        numberAxis2.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, numberAxis, numberAxis2, null);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1, standardXYToolTipGenerator, standardXYURLGenerator);
        standardXYItemRenderer.setShapesFilled(Boolean.TRUE);
        xYPlot.setRenderer(standardXYItemRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createBubbleChart(String string2, String string3, String string4, XYZDataset xYZDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string4);
        numberAxis2.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYZDataset, numberAxis, numberAxis2, null);
        StandardXYZToolTipGenerator standardXYZToolTipGenerator = null;
        if (bl2) {
            standardXYZToolTipGenerator = new StandardXYZToolTipGenerator();
        }
        StandardXYZURLGenerator standardXYZURLGenerator = null;
        if (bl3) {
            standardXYZURLGenerator = new StandardXYZURLGenerator();
        }
        XYBubbleRenderer xYBubbleRenderer = new XYBubbleRenderer(2);
        xYBubbleRenderer.setToolTipGenerator(standardXYZToolTipGenerator);
        xYBubbleRenderer.setURLGenerator(standardXYZURLGenerator);
        xYPlot.setRenderer(xYBubbleRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createWindPlot(String string2, String string3, String string4, WindDataset windDataset, boolean bl, boolean bl2, boolean bl3) {
        DateAxis dateAxis = new DateAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        numberAxis.setRange(-12.0, 12.0);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYPlot xYPlot = new XYPlot(windDataset, dateAxis, numberAxis, null);
        WindItemRenderer windItemRenderer = new WindItemRenderer();
        windItemRenderer.setToolTipGenerator(standardXYToolTipGenerator);
        windItemRenderer.setURLGenerator(standardXYURLGenerator);
        xYPlot.setRenderer(windItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createTimeSeriesChart(String string2, String string3, String string4, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        DateAxis dateAxis = new DateAxis(string3);
        dateAxis.setLowerMargin(0.02);
        dateAxis.setUpperMargin(0.02);
        NumberAxis numberAxis = new NumberAxis(string4);
        numberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, dateAxis, numberAxis, null);
        TimeSeriesToolTipGenerator timeSeriesToolTipGenerator = null;
        if (bl2) {
            timeSeriesToolTipGenerator = new TimeSeriesToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new StandardXYItemRenderer(2, timeSeriesToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createXYBarChart(String string2, String string3, String string4, IntervalXYDataset intervalXYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        DateAxis dateAxis = new DateAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        xYBarRenderer.setToolTipGenerator(standardXYToolTipGenerator);
        xYBarRenderer.setURLGenerator(standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(intervalXYDataset, dateAxis, numberAxis, xYBarRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHighLowChart(String string2, String string3, String string4, HighLowDataset highLowDataset, boolean bl) {
        DateAxis dateAxis = new DateAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        highLowRenderer.setToolTipGenerator(new HighLowToolTipGenerator());
        XYPlot xYPlot = new XYPlot(highLowDataset, dateAxis, numberAxis, highLowRenderer);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHighLowChart(String string2, String string3, String string4, HighLowDataset highLowDataset, Timeline timeline, boolean bl) {
        DateAxis dateAxis = new DateAxis(string3, timeline);
        NumberAxis numberAxis = new NumberAxis(string4);
        HighLowRenderer highLowRenderer = new HighLowRenderer();
        highLowRenderer.setToolTipGenerator(new HighLowToolTipGenerator());
        XYPlot xYPlot = new XYPlot(highLowDataset, dateAxis, numberAxis, highLowRenderer);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createCandlestickChart(String string2, String string3, String string4, HighLowDataset highLowDataset, boolean bl) {
        DateAxis dateAxis = new DateAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        XYPlot xYPlot = new XYPlot(highLowDataset, dateAxis, numberAxis, null);
        xYPlot.setRenderer(new CandlestickRenderer());
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createSignalChart(String string2, String string3, String string4, SignalsDataset signalsDataset, boolean bl) {
        DateAxis dateAxis = new DateAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        XYPlot xYPlot = new XYPlot(signalsDataset, dateAxis, numberAxis, null);
        xYPlot.setRenderer(new SignalRenderer());
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createXYStepChart(String string2, String string3, String string4, XYDataset xYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        DateAxis dateAxis = new DateAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYStepRenderer xYStepRenderer = new XYStepRenderer(standardXYToolTipGenerator, standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(xYDataset, dateAxis, numberAxis, null);
        xYPlot.setRenderer(xYStepRenderer);
        xYPlot.setOrientation(plotOrientation);
        xYPlot.setDomainCrosshairVisible(false);
        xYPlot.setRangeCrosshairVisible(false);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHistogram(String string2, String string3, String string4, IntervalXYDataset intervalXYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        NumberAxis numberAxis = new NumberAxis(string3);
        NumberAxis numberAxis2 = new NumberAxis(string4);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYBarRenderer xYBarRenderer = new XYBarRenderer();
        xYBarRenderer.setToolTipGenerator(standardXYToolTipGenerator);
        xYBarRenderer.setURLGenerator(standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(intervalXYDataset, numberAxis, numberAxis2, null);
        xYPlot.setRenderer(xYBarRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedAreaXYChart(String string2, String string3, String string4, TableXYDataset tableXYDataset, PlotOrientation plotOrientation, boolean bl, boolean bl2, boolean bl3) {
        NumberAxis numberAxis = new NumberAxis(string3);
        numberAxis.setAutoRangeIncludesZero(false);
        NumberAxis numberAxis2 = new NumberAxis(string4);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        StackedAreaXYRenderer stackedAreaXYRenderer = new StackedAreaXYRenderer(4, standardXYToolTipGenerator, standardXYURLGenerator);
        stackedAreaXYRenderer.setOutline(true);
        XYPlot xYPlot = new XYPlot(tableXYDataset, numberAxis, numberAxis2, stackedAreaXYRenderer);
        xYPlot.setOrientation(plotOrientation);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createBoxAndWhiskerChart(String string2, String string3, String string4, BoxAndWhiskerXYDataset boxAndWhiskerXYDataset, boolean bl) {
        DateAxis dateAxis = new DateAxis(string3);
        NumberAxis numberAxis = new NumberAxis(string4);
        numberAxis.setAutoRangeIncludesZero(false);
        XYBoxAndWhiskerRenderer xYBoxAndWhiskerRenderer = new XYBoxAndWhiskerRenderer(10.0);
        XYPlot xYPlot = new XYPlot(boxAndWhiskerXYDataset, dateAxis, numberAxis, xYBoxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart(string2, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }
}

