/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.data.CategoryDataset;

public class StandardCategoryItemLabelGenerator
implements CategoryItemLabelGenerator,
Cloneable,
Serializable {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    public StandardCategoryItemLabelGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardCategoryItemLabelGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.dateFormat = null;
    }

    public StandardCategoryItemLabelGenerator(DateFormat dateFormat) {
        this.numberFormat = null;
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
        String string2 = null;
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            Comparable comparable = categoryDataset.getRowKey(n);
            if (comparable != null) {
                string2 = comparable.toString() + ", ";
            }
            Comparable comparable2 = categoryDataset.getColumnKey(n2);
            String string3 = comparable2.toString();
            String string4 = null;
            if (this.numberFormat != null) {
                string4 = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                string4 = this.dateFormat.format(number);
            }
            string2 = string2 != null ? string2 + string3 + " = " + string4 : string3 + " = " + string4;
        }
        return string2;
    }

    public String generateItemLabel(CategoryDataset categoryDataset, int n, int n2) {
        String string2 = null;
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            if (this.numberFormat != null) {
                string2 = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                string2 = this.dateFormat.format(number);
            }
        }
        return string2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardCategoryItemLabelGenerator) {
            StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = (StandardCategoryItemLabelGenerator)object;
            if (this.dateFormat != null) {
                return this.dateFormat.equals(standardCategoryItemLabelGenerator.dateFormat);
            }
            return this.numberFormat.equals(standardCategoryItemLabelGenerator.numberFormat);
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = (StandardCategoryItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            standardCategoryItemLabelGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.dateFormat != null) {
            standardCategoryItemLabelGenerator.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        return standardCategoryItemLabelGenerator;
    }
}

