/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;

public class TimeSeriesURLGenerator
implements XYURLGenerator,
Serializable {
    private DateFormat dateFormat = DateFormat.getInstance();
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String itemParameterName = "item";

    public TimeSeriesURLGenerator() {
    }

    public TimeSeriesURLGenerator(DateFormat dateFormat, String string2, String string3, String string4) {
        this.dateFormat = dateFormat;
        this.prefix = string2;
        this.seriesParameterName = string3;
        this.itemParameterName = string4;
    }

    public String generateURL(XYDataset xYDataset, int n, int n2) {
        String string2 = this.prefix;
        boolean bl = string2.indexOf("?") == -1;
        String string3 = xYDataset.getSeriesName(n);
        if (string3 != null) {
            string2 = string2 + (bl ? "?" : "&");
            string2 = string2 + this.seriesParameterName + "=" + string3;
            bl = false;
        }
        long l = xYDataset.getXValue(n, n2).longValue();
        String string4 = this.dateFormat.format(new Date(l));
        string2 = string2 + (bl ? "?" : "&");
        string2 = string2 + this.itemParameterName + "=" + string4;
        return string2;
    }
}

