/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import org.jfree.data.Series;

public class MatrixSeries
extends Series
implements Serializable {
    protected double[][] m_data;

    public MatrixSeries(String string2, int n, int n2) {
        super(string2);
        this.m_data = new double[n][n2];
        this.zeroAll();
    }

    public int getColumnsCount() {
        return this.m_data[0].length;
    }

    public Number getItem(int n) {
        int n2 = this.getItemRow(n);
        int n3 = this.getItemColumn(n);
        Double d = new Double(this.get(n2, n3));
        return d;
    }

    public int getItemColumn(int n) {
        return n % this.getRowCount();
    }

    public int getItemCount() {
        return this.getRowCount() * this.getColumnsCount();
    }

    public int getItemRow(int n) {
        return n / this.getRowCount();
    }

    public int getRowCount() {
        return this.m_data.length;
    }

    public double get(int n, int n2) {
        return this.m_data[n][n2];
    }

    public void update(int n, int n2, double d) {
        this.m_data[n][n2] = d;
        this.fireSeriesChanged();
    }

    public void zeroAll() {
        double[][] dArray = this.m_data;
        int n = this.getRowCount();
        int n2 = this.getColumnsCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = 0.0;
            }
        }
        this.fireSeriesChanged();
    }
}

