/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.Range;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimePeriodValue;
import org.jfree.data.time.TimePeriodValues;

public class TimePeriodValuesCollection
extends AbstractSeriesDataset
implements IntervalXYDataset,
DomainInfo,
Serializable {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private List data = new ArrayList();
    private TimePeriodAnchor xPosition = TimePeriodAnchor.MIDDLE;
    private boolean domainIsPointsInTime = true;

    public TimePeriodValuesCollection() {
        this((TimePeriodValues)null);
    }

    public TimePeriodValuesCollection(TimeZone timeZone) {
        this(null, timeZone);
    }

    public TimePeriodValuesCollection(TimePeriodValues timePeriodValues) {
        if (timePeriodValues != null) {
            this.data.add(timePeriodValues);
            timePeriodValues.addChangeListener(this);
        }
    }

    public TimePeriodValuesCollection(TimePeriodValues timePeriodValues, TimeZone timeZone) {
        this(timePeriodValues);
    }

    public int getPosition() {
        TimePeriodAnchor timePeriodAnchor = this.getXPosition();
        if (timePeriodAnchor == TimePeriodAnchor.START) {
            return 0;
        }
        if (timePeriodAnchor == TimePeriodAnchor.MIDDLE) {
            return 1;
        }
        if (timePeriodAnchor == TimePeriodAnchor.END) {
            return 2;
        }
        return 1;
    }

    public void setPosition(int n) {
        if (n == 0) {
            this.setXPosition(TimePeriodAnchor.START);
        } else if (n == 1) {
            this.setXPosition(TimePeriodAnchor.MIDDLE);
        } else if (n == 2) {
            this.setXPosition(TimePeriodAnchor.END);
        }
    }

    public TimePeriodAnchor getXPosition() {
        return this.xPosition;
    }

    public void setXPosition(TimePeriodAnchor timePeriodAnchor) {
        this.xPosition = timePeriodAnchor;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean bl) {
        this.domainIsPointsInTime = bl;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public TimePeriodValues getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("TimePeriodValuesCollection.getSeries(...): index outside valid range.");
        }
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        return timePeriodValues;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public void addSeries(TimePeriodValues timePeriodValues) {
        if (timePeriodValues == null) {
            throw new IllegalArgumentException("TimePeriodValuesCollection.addSeries(...): cannot add null series.");
        }
        this.data.add(timePeriodValues);
        timePeriodValues.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(TimePeriodValues timePeriodValues) {
        if (timePeriodValues == null) {
            throw new IllegalArgumentException("TimePeriodValuesCollection.addSeries(...): cannot add null series.");
        }
        this.data.remove(timePeriodValues);
        timePeriodValues.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        TimePeriodValues timePeriodValues = this.getSeries(n);
        if (timePeriodValues != null) {
            this.removeSeries(timePeriodValues);
        }
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(n2);
        TimePeriod timePeriod = timePeriodValue.getPeriod();
        return new Long(this.getX(timePeriod));
    }

    private long getX(TimePeriod timePeriod) {
        long l = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            l = timePeriod.getStart().getTime();
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            l = timePeriod.getStart().getTime() / 2L + timePeriod.getEnd().getTime() / 2L;
        } else if (this.xPosition == TimePeriodAnchor.END) {
            l = timePeriod.getEnd().getTime();
        } else {
            throw new IllegalStateException("TimePeriodValuesCollection.getX(...).");
        }
        return l;
    }

    public Number getStartXValue(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(n2);
        return new Long(timePeriodValue.getPeriod().getStart().getTime());
    }

    public Number getEndXValue(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(n2);
        return new Long(timePeriodValue.getPeriod().getEnd().getTime());
    }

    public Number getYValue(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(n2);
        return timePeriodValue.getValue();
    }

    public Number getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getMinimumDomainValue() {
        Range range = this.getDomainRange();
        return new Double(range.getLowerBound());
    }

    public Number getMaximumDomainValue() {
        Range range = this.getDomainRange();
        return new Double(range.getUpperBound());
    }

    public Range getDomainRange() {
        Range range = null;
        Range range2 = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TimePeriodValues timePeriodValues = (TimePeriodValues)iterator.next();
            int n = timePeriodValues.getItemCount();
            if (n <= 0) continue;
            TimePeriod timePeriod = timePeriodValues.getTimePeriod(timePeriodValues.getMinStartIndex());
            TimePeriod timePeriod2 = timePeriodValues.getTimePeriod(timePeriodValues.getMaxEndIndex());
            if (this.domainIsPointsInTime) {
                TimePeriod timePeriod3;
                if (this.xPosition == TimePeriodAnchor.START) {
                    timePeriod3 = timePeriodValues.getTimePeriod(timePeriodValues.getMaxStartIndex());
                    range2 = new Range(timePeriod.getStart().getTime(), timePeriod3.getStart().getTime());
                } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
                    timePeriod3 = timePeriodValues.getTimePeriod(timePeriodValues.getMinMiddleIndex());
                    long l = timePeriod3.getStart().getTime();
                    long l2 = timePeriod3.getEnd().getTime();
                    TimePeriod timePeriod4 = timePeriodValues.getTimePeriod(timePeriodValues.getMaxMiddleIndex());
                    long l3 = timePeriod4.getStart().getTime();
                    long l4 = timePeriod4.getEnd().getTime();
                    range2 = new Range(l + (l2 - l) / 2L, l3 + (l4 - l3) / 2L);
                } else if (this.xPosition == TimePeriodAnchor.END) {
                    timePeriod3 = timePeriodValues.getTimePeriod(timePeriodValues.getMinEndIndex());
                    range2 = new Range(timePeriod3.getEnd().getTime(), timePeriod2.getEnd().getTime());
                }
            } else {
                range2 = new Range(timePeriod.getStart().getTime(), timePeriod2.getEnd().getTime());
            }
            range = Range.combine(range, range2);
        }
        return range;
    }
}

