/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jfree.data.Series;
import org.jfree.data.SeriesException;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeries
extends Series
implements Cloneable,
Serializable {
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    protected Class timePeriodClass;
    protected List data;
    private int maximumItemCount;
    private int historyCount;
    static /* synthetic */ Class class$org$jfree$data$time$Day;

    public TimeSeries(String string2) {
        this(string2, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = TimeSeries.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day);
    }

    public TimeSeries(String string2, Class clazz) {
        this(string2, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, clazz);
    }

    public TimeSeries(String string2, String string3, String string4, Class clazz) {
        super(string2);
        this.domain = string3;
        this.range = string4;
        this.timePeriodClass = clazz;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.historyCount = 0;
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string2) {
        String string3 = this.domain;
        this.domain = string2;
        this.firePropertyChange("Domain", string3, string2);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string2) {
        String string3 = this.range;
        this.range = string2;
        this.firePropertyChange("Range", string3, string2);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int n) {
        this.historyCount = n;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public TimeSeriesDataItem getDataPair(int n) {
        return this.getDataItem(n);
    }

    public TimeSeriesDataItem getDataItem(int n) {
        return (TimeSeriesDataItem)this.data.get(n);
    }

    public TimeSeriesDataItem getDataPair(RegularTimePeriod regularTimePeriod) {
        return this.getDataItem(regularTimePeriod);
    }

    public TimeSeriesDataItem getDataItem(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("TimeSeries.getDataItem(...): null time period not allowed.");
        }
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, new Integer(0));
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n >= 0) {
            return (TimeSeriesDataItem)this.data.get(n);
        }
        return null;
    }

    public RegularTimePeriod getTimePeriod(int n) {
        return this.getDataPair(n).getPeriod();
    }

    public RegularTimePeriod getNextTimePeriod() {
        RegularTimePeriod regularTimePeriod = this.getTimePeriod(this.getItemCount() - 1);
        return regularTimePeriod.next();
    }

    public Collection getTimePeriods() {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        for (int i = 0; i < this.getItemCount(); ++i) {
            arrayList.add(this.getTimePeriod(i));
        }
        return arrayList;
    }

    public Collection getTimePeriodsUniqueToOtherSeries(TimeSeries timeSeries) {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(i);
            int n = this.getIndex(regularTimePeriod);
            if (n >= 0) continue;
            arrayList.add(regularTimePeriod);
        }
        return arrayList;
    }

    public int getIndex(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("TimeSeries.getIndex(...) : null not permitted.");
        }
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, new Integer(0));
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        return n;
    }

    public Number getValue(int n) {
        return this.getDataPair(n).getValue();
    }

    public Number getValue(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        if (n >= 0) {
            return this.getValue(n);
        }
        return null;
    }

    public void add(TimeSeriesDataItem timeSeriesDataItem) throws SeriesException {
        if (timeSeriesDataItem == null) {
            throw new IllegalArgumentException("TimeSeries.add(...): null item not allowed.");
        }
        if (!timeSeriesDataItem.getPeriod().getClass().equals(this.timePeriodClass)) {
            String string2 = "TimeSeries.add(): you are trying to add data where the time ";
            string2 = string2 + "period class is " + timeSeriesDataItem.getPeriod().getClass().getName() + ", ";
            string2 = string2 + "but the TimeSeries is expecting an instance of " + this.timePeriodClass.getName() + ".";
            throw new SeriesException(string2);
        }
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n < 0) {
            this.data.add(-n - 1, timeSeriesDataItem);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        } else {
            throw new SeriesException("TimeSeries.add(...): time period already exists.");
        }
        this.ageHistoryCountItems();
        this.fireSeriesChanged();
    }

    public void add(RegularTimePeriod regularTimePeriod, double d) throws SeriesException {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, d);
        this.add(timeSeriesDataItem);
    }

    public void add(RegularTimePeriod regularTimePeriod, Number number) throws SeriesException {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        this.add(timeSeriesDataItem);
    }

    public void update(RegularTimePeriod regularTimePeriod, Number number) throws SeriesException {
        TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem);
        if (n < 0) {
            throw new SeriesException("TimeSeries.update(TimePeriod, Number): period does not exist.");
        }
        TimeSeriesDataItem timeSeriesDataItem2 = (TimeSeriesDataItem)this.data.get(n);
        timeSeriesDataItem2.setValue(number);
        this.fireSeriesChanged();
    }

    public void update(int n, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = this.getDataPair(n);
        timeSeriesDataItem.setValue(number);
        this.fireSeriesChanged();
    }

    public TimeSeries addAndOrUpdate(TimeSeries timeSeries) {
        TimeSeries timeSeries2 = new TimeSeries("Overwritten values from: " + this.getName());
        for (int i = 0; i < timeSeries.getItemCount(); ++i) {
            TimeSeriesDataItem timeSeriesDataItem = timeSeries.getDataPair(i);
            TimeSeriesDataItem timeSeriesDataItem2 = this.addOrUpdate(timeSeriesDataItem.getPeriod(), timeSeriesDataItem.getValue());
            if (timeSeriesDataItem2 == null) continue;
            try {
                timeSeries2.add(timeSeriesDataItem2);
                continue;
            }
            catch (SeriesException seriesException) {
                System.err.println("TimeSeries.addAndOrUpdate(series): unable to add data to overwritten series.");
            }
        }
        return timeSeries2;
    }

    public TimeSeriesDataItem addOrUpdate(RegularTimePeriod regularTimePeriod, Number number) {
        TimeSeriesDataItem timeSeriesDataItem = null;
        TimeSeriesDataItem timeSeriesDataItem2 = new TimeSeriesDataItem(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataItem2);
        if (n >= 0) {
            TimeSeriesDataItem timeSeriesDataItem3 = (TimeSeriesDataItem)this.data.get(n);
            timeSeriesDataItem = (TimeSeriesDataItem)timeSeriesDataItem3.clone();
            timeSeriesDataItem3.setValue(number);
            this.ageHistoryCountItems();
            this.fireSeriesChanged();
        } else {
            this.data.add(-n - 1, new TimeSeriesDataItem(regularTimePeriod, number));
            this.ageHistoryCountItems();
            this.fireSeriesChanged();
        }
        return timeSeriesDataItem;
    }

    public void ageHistoryCountItems() {
        if (this.getItemCount() > 1 && this.historyCount > 0) {
            long l = this.getTimePeriod(this.getItemCount() - 1).getSerialIndex();
            while (l - this.getTimePeriod(0).getSerialIndex() >= (long)this.historyCount) {
                this.data.remove(0);
            }
        }
    }

    public void ageHistoryCountItems(long l) {
        if (this.getItemCount() > 1 && this.historyCount > 0) {
            while (l - this.getTimePeriod(0).getSerialIndex() >= (long)this.historyCount) {
                this.data.remove(0);
            }
        }
    }

    public void delete(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        this.data.remove(n);
    }

    public void delete(int n, int n2) {
        for (int i = 0; i <= n2 - n; ++i) {
            this.data.remove(n);
        }
        this.fireSeriesChanged();
    }

    public Object clone() {
        TimeSeries timeSeries = this.createCopy(0, this.getItemCount() - 1);
        return timeSeries;
    }

    public TimeSeries createCopy(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)super.clone();
        timeSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i = n; i <= n2; ++i) {
                TimeSeriesDataItem timeSeriesDataItem = (TimeSeriesDataItem)this.data.get(i);
                TimeSeriesDataItem timeSeriesDataItem2 = (TimeSeriesDataItem)timeSeriesDataItem.clone();
                try {
                    timeSeries.add(timeSeriesDataItem2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    System.err.println("TimeSeries.createCopy(): unable to add cloned data pair.");
                }
            }
        }
        return timeSeries;
    }

    public TimeSeries createCopy(RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) {
        int n;
        int n2 = this.getIndex(regularTimePeriod);
        if (n2 < 0) {
            n2 = -(n2 + 1);
        }
        if ((n = this.getIndex(regularTimePeriod2)) < 0) {
            n = -(n + 1);
            --n;
        }
        TimeSeries timeSeries = this.createCopy(n2, n);
        return timeSeries;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        boolean bl = super.equals(object);
        if (object instanceof TimeSeries) {
            TimeSeries timeSeries = (TimeSeries)object;
            boolean bl2 = this.getDomainDescription().equals(timeSeries.getDomainDescription());
            boolean bl3 = this.getRangeDescription().equals(timeSeries.getRangeDescription());
            boolean bl4 = this.getClass().equals(timeSeries.getClass());
            boolean bl5 = this.getHistoryCount() == timeSeries.getHistoryCount();
            boolean bl6 = this.getMaximumItemCount() == timeSeries.getMaximumItemCount();
            boolean bl7 = bl = bl && bl2 && bl3 && bl4 && bl5 && bl6;
            if (bl) {
                boolean bl8 = true;
                int n = this.getItemCount();
                if (n == timeSeries.getItemCount()) {
                    for (int i = 0; i < n; ++i) {
                        boolean bl9 = bl8 = bl8 && this.getDataPair(i).equals(timeSeries.getDataPair(i));
                        if (bl8) continue;
                    }
                    bl = bl8;
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

