/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;

public class svm_toy
extends Applet {
    static final String DEFAULT_PARAM = "-t 2 -c 100";
    int XLEN;
    int YLEN;
    Image buffer;
    Graphics buffer_gc;
    static final Color[] colors = new Color[]{new Color(0, 0, 0), new Color(0, 120, 120), new Color(120, 120, 0), new Color(120, 0, 120), new Color(0, 200, 200), new Color(200, 200, 0), new Color(200, 0, 200)};
    Vector point_list = new Vector();
    byte current_value = 1;

    public void init() {
        this.setSize(this.getSize());
        final Button button = new Button("Change");
        Button button2 = new Button("Run");
        Button button3 = new Button("Clear");
        Button button4 = new Button("Save");
        Button button5 = new Button("Load");
        final TextField textField = new TextField(DEFAULT_PARAM);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(button, gridBagConstraints);
        gridBagLayout.setConstraints(button2, gridBagConstraints);
        gridBagLayout.setConstraints(button3, gridBagConstraints);
        gridBagLayout.setConstraints(button4, gridBagConstraints);
        gridBagLayout.setConstraints(button5, gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.gridwidth = 5;
        gridBagLayout.setConstraints(textField, gridBagConstraints);
        button.setBackground(colors[this.current_value]);
        panel.add(button);
        panel.add(button2);
        panel.add(button3);
        panel.add(button4);
        panel.add(button5);
        panel.add(textField);
        this.add((Component)panel, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                svm_toy.this.button_change_clicked();
                button.setBackground(colors[svm_toy.this.current_value]);
            }
        });
        button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                svm_toy.this.button_run_clicked(textField.getText());
            }
        });
        button3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                svm_toy.this.button_clear_clicked();
            }
        });
        button4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                svm_toy.this.button_save_clicked();
            }
        });
        button5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                svm_toy.this.button_load_clicked();
            }
        });
        textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                svm_toy.this.button_run_clicked(textField.getText());
            }
        });
        this.enableEvents(16L);
    }

    void draw_point(point point2) {
        Color color = colors[point2.value + 3];
        Graphics graphics = this.getGraphics();
        this.buffer_gc.setColor(color);
        this.buffer_gc.fillRect((int)(point2.x * (double)this.XLEN), (int)(point2.y * (double)this.YLEN), 4, 4);
        graphics.setColor(color);
        graphics.fillRect((int)(point2.x * (double)this.XLEN), (int)(point2.y * (double)this.YLEN), 4, 4);
    }

    void clear_all() {
        this.point_list.removeAllElements();
        if (this.buffer != null) {
            this.buffer_gc.setColor(colors[0]);
            this.buffer_gc.fillRect(0, 0, this.XLEN, this.YLEN);
        }
        this.repaint();
    }

    void draw_all_points() {
        int n = this.point_list.size();
        for (int i = 0; i < n; ++i) {
            this.draw_point((point)this.point_list.elementAt(i));
        }
    }

    void button_change_clicked() {
        this.current_value = (byte)(this.current_value + 1);
        if (this.current_value > 3) {
            this.current_value = 1;
        }
    }

    private static double atof(String string2) {
        return Double.valueOf(string2);
    }

    private static int atoi(String string2) {
        return Integer.parseInt(string2);
    }

    void button_run_clicked(String string2) {
        int n;
        if (this.point_list.isEmpty()) {
            return;
        }
        svm_parameter svm_parameter2 = new svm_parameter();
        svm_parameter2.svm_type = 0;
        svm_parameter2.kernel_type = 2;
        svm_parameter2.degree = 3;
        svm_parameter2.gamma = 0.0;
        svm_parameter2.coef0 = 0.0;
        svm_parameter2.nu = 0.5;
        svm_parameter2.cache_size = 40.0;
        svm_parameter2.C = 1.0;
        svm_parameter2.eps = 0.001;
        svm_parameter2.p = 0.1;
        svm_parameter2.shrinking = 1;
        svm_parameter2.probability = 0;
        svm_parameter2.nr_weight = 0;
        svm_parameter2.weight_label = new int[0];
        svm_parameter2.weight = new double[0];
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringTokenizer.nextToken();
        }
        block16: for (n = 0; n < stringArray.length && stringArray[n].charAt(0) == '-'; ++n) {
            if (++n >= stringArray.length) {
                System.err.print("unknown option\n");
                break;
            }
            switch (stringArray[n - 1].charAt(1)) {
                case 's': {
                    svm_parameter2.svm_type = svm_toy.atoi(stringArray[n]);
                    continue block16;
                }
                case 't': {
                    svm_parameter2.kernel_type = svm_toy.atoi(stringArray[n]);
                    continue block16;
                }
                case 'd': {
                    svm_parameter2.degree = svm_toy.atoi(stringArray[n]);
                    continue block16;
                }
                case 'g': {
                    svm_parameter2.gamma = svm_toy.atof(stringArray[n]);
                    continue block16;
                }
                case 'r': {
                    svm_parameter2.coef0 = svm_toy.atof(stringArray[n]);
                    continue block16;
                }
                case 'n': {
                    svm_parameter2.nu = svm_toy.atof(stringArray[n]);
                    continue block16;
                }
                case 'm': {
                    svm_parameter2.cache_size = svm_toy.atof(stringArray[n]);
                    continue block16;
                }
                case 'c': {
                    svm_parameter2.C = svm_toy.atof(stringArray[n]);
                    continue block16;
                }
                case 'e': {
                    svm_parameter2.eps = svm_toy.atof(stringArray[n]);
                    continue block16;
                }
                case 'p': {
                    svm_parameter2.p = svm_toy.atof(stringArray[n]);
                    continue block16;
                }
                case 'h': {
                    svm_parameter2.shrinking = svm_toy.atoi(stringArray[n]);
                    continue block16;
                }
                case 'b': {
                    svm_parameter2.probability = svm_toy.atoi(stringArray[n]);
                    continue block16;
                }
                case 'w': {
                    ++svm_parameter2.nr_weight;
                    Object[] objectArray = svm_parameter2.weight_label;
                    svm_parameter2.weight_label = new int[svm_parameter2.nr_weight];
                    System.arraycopy(objectArray, 0, svm_parameter2.weight_label, 0, svm_parameter2.nr_weight - 1);
                    objectArray = svm_parameter2.weight;
                    svm_parameter2.weight = new double[svm_parameter2.nr_weight];
                    System.arraycopy(objectArray, 0, svm_parameter2.weight, 0, svm_parameter2.nr_weight - 1);
                    svm_parameter2.weight_label[svm_parameter2.nr_weight - 1] = svm_toy.atoi(stringArray[n - 1].substring(2));
                    svm_parameter2.weight[svm_parameter2.nr_weight - 1] = svm_toy.atof(stringArray[n]);
                    continue block16;
                }
                default: {
                    System.err.print("unknown option\n");
                }
            }
        }
        svm_problem svm_problem2 = new svm_problem();
        svm_problem2.l = this.point_list.size();
        svm_problem2.y = new double[svm_problem2.l];
        if (svm_parameter2.kernel_type != 4) {
            if (svm_parameter2.svm_type == 3 || svm_parameter2.svm_type == 4) {
                int n2;
                svm_node[] svm_nodeArray;
                if (svm_parameter2.gamma == 0.0) {
                    svm_parameter2.gamma = 1.0;
                }
                svm_problem2.x = new svm_node[svm_problem2.l][1];
                for (int i = 0; i < svm_problem2.l; ++i) {
                    svm_nodeArray = (svm_node[])this.point_list.elementAt(i);
                    svm_problem2.x[i][0] = new svm_node();
                    svm_problem2.x[i][0].index = 1;
                    svm_problem2.x[i][0].value = svm_nodeArray.x;
                    svm_problem2.y[i] = svm_nodeArray.y;
                }
                svm_model svm_model2 = svm.svm_train(svm_problem2, svm_parameter2);
                svm_nodeArray = new svm_node[]{new svm_node()};
                svm_nodeArray[0].index = 1;
                int[] nArray = new int[this.XLEN];
                Graphics graphics = this.getGraphics();
                for (n2 = 0; n2 < this.XLEN; ++n2) {
                    svm_nodeArray[0].value = (double)n2 / (double)this.XLEN;
                    nArray[n2] = (int)((double)this.YLEN * svm.svm_predict(svm_model2, svm_nodeArray));
                }
                this.buffer_gc.setColor(colors[0]);
                this.buffer_gc.drawLine(0, 0, 0, this.YLEN - 1);
                graphics.setColor(colors[0]);
                graphics.drawLine(0, 0, 0, this.YLEN - 1);
                n2 = (int)(svm_parameter2.p * (double)this.YLEN);
                for (int i = 1; i < this.XLEN; ++i) {
                    this.buffer_gc.setColor(colors[0]);
                    this.buffer_gc.drawLine(i, 0, i, this.YLEN - 1);
                    graphics.setColor(colors[0]);
                    graphics.drawLine(i, 0, i, this.YLEN - 1);
                    this.buffer_gc.setColor(colors[5]);
                    graphics.setColor(colors[5]);
                    this.buffer_gc.drawLine(i - 1, nArray[i - 1], i, nArray[i]);
                    graphics.drawLine(i - 1, nArray[i - 1], i, nArray[i]);
                    if (svm_parameter2.svm_type != 3) continue;
                    this.buffer_gc.setColor(colors[2]);
                    graphics.setColor(colors[2]);
                    this.buffer_gc.drawLine(i - 1, nArray[i - 1] + n2, i, nArray[i] + n2);
                    graphics.drawLine(i - 1, nArray[i - 1] + n2, i, nArray[i] + n2);
                    this.buffer_gc.setColor(colors[2]);
                    graphics.setColor(colors[2]);
                    this.buffer_gc.drawLine(i - 1, nArray[i - 1] - n2, i, nArray[i] - n2);
                    graphics.drawLine(i - 1, nArray[i - 1] - n2, i, nArray[i] - n2);
                }
            } else {
                svm_node[] svm_nodeArray;
                if (svm_parameter2.gamma == 0.0) {
                    svm_parameter2.gamma = 0.5;
                }
                svm_problem2.x = new svm_node[svm_problem2.l][2];
                for (int i = 0; i < svm_problem2.l; ++i) {
                    svm_nodeArray = (svm_node[])this.point_list.elementAt(i);
                    svm_problem2.x[i][0] = new svm_node();
                    svm_problem2.x[i][0].index = 1;
                    svm_problem2.x[i][0].value = svm_nodeArray.x;
                    svm_problem2.x[i][1] = new svm_node();
                    svm_problem2.x[i][1].index = 2;
                    svm_problem2.x[i][1].value = svm_nodeArray.y;
                    svm_problem2.y[i] = svm_nodeArray.value;
                }
                svm_model svm_model3 = svm.svm_train(svm_problem2, svm_parameter2);
                svm_nodeArray = new svm_node[]{new svm_node(), new svm_node()};
                svm_nodeArray[0].index = 1;
                svm_nodeArray[1].index = 2;
                Graphics graphics = this.getGraphics();
                for (int i = 0; i < this.XLEN; ++i) {
                    for (int j = 0; j < this.YLEN; ++j) {
                        svm_nodeArray[0].value = (double)i / (double)this.XLEN;
                        svm_nodeArray[1].value = (double)j / (double)this.YLEN;
                        double d = svm.svm_predict(svm_model3, svm_nodeArray);
                        if (svm_parameter2.svm_type == 2 && d < 0.0) {
                            d = 2.0;
                        }
                        this.buffer_gc.setColor(colors[(int)d]);
                        graphics.setColor(colors[(int)d]);
                        this.buffer_gc.drawLine(i, j, i, j);
                        graphics.drawLine(i, j, i, j);
                    }
                }
            }
        }
        this.draw_all_points();
    }

    void button_clear_clicked() {
        this.clear_all();
    }

    void button_save_clicked() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Save", 1);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
            int n = this.point_list.size();
            for (int i = 0; i < n; ++i) {
                point point2 = (point)this.point_list.elementAt(i);
                dataOutputStream.writeBytes(point2.value + " 1:" + point2.x + " 2:" + point2.y + "\n");
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.print(iOException);
        }
    }

    void button_load_clicked() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Load", 0);
        fileDialog.setVisible(true);
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        this.clear_all();
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, " \t\n\r\f:");
                byte by = (byte)svm_toy.atoi(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                double d = svm_toy.atof(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                double d2 = svm_toy.atof(stringTokenizer.nextToken());
                this.point_list.addElement(new point(d, d2, by));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.print(iOException);
        }
        this.draw_all_points();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            if (mouseEvent.getX() >= this.XLEN || mouseEvent.getY() >= this.YLEN) {
                return;
            }
            point point2 = new point((double)mouseEvent.getX() / (double)this.XLEN, (double)mouseEvent.getY() / (double)this.YLEN, this.current_value);
            this.point_list.addElement(point2);
            this.draw_point(point2);
        }
    }

    public void paint(Graphics graphics) {
        if (this.buffer == null) {
            this.buffer = this.createImage(this.XLEN, this.YLEN);
            this.buffer_gc = this.buffer.getGraphics();
            this.buffer_gc.setColor(colors[0]);
            this.buffer_gc.fillRect(0, 0, this.XLEN, this.YLEN);
        }
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.XLEN, this.YLEN + 50);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.XLEN = n;
        this.YLEN = n2 - 50;
        this.clear_all();
    }

    public static void main(String[] stringArray) {
        new AppletFrame("svm_toy", new svm_toy(), 500, 550);
    }

    class point {
        double x;
        double y;
        byte value;

        point(double d, double d2, byte by) {
            this.x = d;
            this.y = d2;
            this.value = by;
        }
    }
}

