
@echo off

if "%~1"=="" goto python

if "%~2"=="" goto input

if "%~3"=="" goto java


REM %* all args: %1 first arg = c:\python27\python.exe, %2 is the file that contains the dosages, %3 javapath (in my case is "c:\program files (x86)\java\jre7\bin\java.exe")

mkdir temp

REM I am moving here the scripts that will generate the individual file for each of the prescriptions into the prescription data folder

REM moving into the prescription data

%1 scripts\drug_information_extraction.py %2 scripts\stoplist2.txt pr temp\

REM extracting the data into individual files. PR is the name of the intermediate file.

REM give as an input the directory of the data that you want to extract the medication dosage

%3 -Xmx1200M -cp minorthird_20080611.jar edu.cmu.minorthird.ui.RunMixup -labels temp\ -mixup scripts\dose_characteristics.mixup -saveAs  temp\spans.labels

REM extracting the necessary spans

%1 scripts\blank_line.py   temp\spans.labels  temp\dosenumber50000.labels

REM removing the blank line from the minorthird produced file

%1 scripts\fil_dose.py  temp\dosenumber50000.labels    temp\fil_dosenumber50000.labels
REM filtering the minorthird spans - this gives the true number of filtered spans

%1 scripts\dose_extraction.py  temp\fil_dosenumber50000.labels   temp\extracted_medinfo50000.txt temp\
REM extract the dose number from the text

%1 scripts\word_digit_con.py  temp\extracted_medinfo50000.txt   temp\converted_dose_numbers50000.txt
REM convert the number from the extracted dose numbers - if they are string, we convert them through a dictionary into numbers

%1 scripts\word_digit_con2.py  temp\converted_dose_numbers50000.txt   temp\new_converted_dose_numbers50000.txt
REM  here we convert the extra 5-50000 ml that have been appearing lately through the rule of the regular expressions - more dose numbers equal as 1 now.

%1 scripts\get_project_text.py   temp\new_converted_dose_numbers50000.txt    temp\new_converted_dose_numbers500002.txt

%1 scripts\column_comparison2.py  temp\new_converted_dose_numbers500002.txt  %2   temp\50000columns.txt   
REM <------------------put original txt dosage file here
REM here we add the dose number column and taken the text from the original source file of cprd data

%1 scripts\required.py  temp\extracted_medinfo50000.txt  temp\50000columns.txt   temp\new_50000columns.txt
REM  here we integrate the field "if it is required\needed

%1 scripts\add_dose_unit.py  temp\extracted_medinfo50000.txt  temp\new_50000columns.txt   temp\all_columns_together50000.txt
REM  here we integrate the following: we add the extracted dosage unit from us 

%1 scripts\freq_word_con.py  temp\extracted_medinfo50000.txt   temp\converted_frequency_numbers50000.txt
REM Hconvert the word frequencies into number - that is probably the toughest of everything :P - probably needs more work when we work with the 1,000 set.

%1 scripts\get_project_text_frequency.py   temp\converted_frequency_numbers50000.txt    temp\converted_frequency_numbers500002.txt

echo "adding here the dose frequency"

%1 scripts\add_dose_frequency.py  temp\converted_frequency_numbers500002.txt  %2  temp\columns_and_frequency50000.txt
REM  this will add the extracted dose frequencies along with the extracted dose numbers :P

%1 scripts\add_columns_frequency.py  temp\columns_and_frequency50000.txt   temp\all_columns_together50000.txt   temp\all_columns_together50000_fr.txt
REM here we are adding together the columns of dose frequency coming from the columsn_and_frequency[number] with the rest of the related information of all_columns_together. :P

%1 scripts\required_conv.py  temp\all_columns_together50000_fr.txt   temp\all_columns_together50000_fr_conv.txt
REM here we include zero in the dose frequency if it says that it is when required\needed\etc

%1 scripts\default_dose_number.py  temp\all_columns_together50000_fr_conv.txt   temp\default_dose_number50000.txt   temp\new_default_dose_number50000.txt
REM  here we converted the zeros into ? for anything i.e., dose number and dose frequency. also defaulting dose number into 1 if there is a frequency or verbs into the sentence.

echo "just before the end"

%1 scripts\conv_dose_interval.py  temp\extracted_medinfo50000.txt   temp\converted_dose_intervals50000.txt
REM here we are converting the extracted text of dose intervals to 1, 2, 3, 4, .... etc :P

%1 scripts\add_dose_interval.py  temp\converted_dose_intervals50000.txt   temp\new_default_dose_number50000.txt   temp\all_columns_together50000_di_conv.txt
REM  here at the end we are adding the last column of dose interval in the final file! end of story! needs to try this in the 50000 lines!

echo "added dose interval"

%1 scripts\csv_output.py temp\all_columns_together50000_di_conv.txt csv_results.csv

echo "done"

RMDIR /S /Q temp


GOTO DONE


:PYTHON

ECHO You need to supply the path to your python executable

GOTO H

:INPUT

ECHO You need to supply the name the inoput file to process (e.g. "example.txt")

GOTO H

:JAVA

ECHO You need to supply the path to your java executable

GOTO H

:DONE

ECHO Done!

GOTO END

:H

ECHO Usage: complete_script.bat python.exe input_file.txt java.exe

GOTO END


:END



